/*
 *  List.cpp
 *
 *  This code is right out of "The Late Night Guide to C++"
 *  pages 241 - 245
 *
 *  LECTURE 22
 *  DEMO 2
 */
#include "StdAfx.h"

#include <iostream>

using namespace std;  //introduces namespace std

#include "List.h"

// Standard destructor
List::~List()
{
  Node *n = the_head;
  
  // Loop through all entries in the list and delete 
  // each one.  
  while (n)
  {
    // Remove "n" from the chain
    Node *nn = n;
    n = n->next;
    
    // Delete the original n
    delete nn;
  }
}

// Get the Length of the List
int List::length() const
{
  int n = 0;
  Node *p = the_head;
  // Traverse the list, counting each element as we go by
  while (p)
  { 
    ++n;
    p = p->next;
  }
  
  return n;
}

// Retrieve the nth element
string List::nth(int n) const
{
  int i = 0;
  Node *p = the_head;
  string emptyStr = "";
  
  // Traverse the list, looking for the nth element
  while (p && i < n)
  {
    ++i;
    p = p->next;
  }
  
  if (p == NULL)
  {
    cerr << "Error: element " << n << " does not exist" << endl;
    return emptyStr;
  }
  
  return p->the_value;
}


// Insert a new element at the nth position
void List::insert(const string &x, int n)
{ 
  if (n < 0)
  {
    cerr << "Error:  Attempting to access a negative index " << endl;
    return;
  }
  
  if (n == 0)
  {
    // If n == 0, insert at the head of the list
    the_head = new Node(x, the_head);
  }
  else
  {
    if (the_head == NULL)
    {
      cerr << "Error:  Attempt to insert an element beyond " <<
              "the end of the list " << endl;
      return;
    }
    
    Node *p = the_head;
    int i = 1;
 
    // Let's find the nth element, shall we?
    while (i < n)
    {
      ++i;
      p = p->next;
      if (p == NULL)
      {
        cerr << "Error: Attempt to insert an element beyond " <<
                "the end of the list " << endl;
        return;
      }
    }
    
    // Insert the new element just after p, but before p->next
    p->next = new Node(x, p->next);
  }
}

// Remove the nth element of a list
void List::remove(int n)
{
  if (n < 0)
  {
    cout << "error: attempting to access a negative index " << endl;
    return;
  }
  
  // Make sure we have a list to delete from!
  if (the_head)
  {
    // If we're deleting the head, treat this specially
    if (n == 1)
    {
      Node *temp = the_head;
      the_head = the_head->next;
      delete temp;
    }
    else
    {
      Node *p = the_head;
      int i = 1;
      while (i < n - 1)
      {
        ++i;
        p = p->next;
        if (p == NULL)
        {
          cerr << "Error: Attempt to delete a non-existent " <<
                  "list element " << endl;
          return;
        }
      }
      
      // We actually want to delete p->next.  If it is NULL,
      // then n is out of bounds
      Node *temp = p->next;
      if (temp == NULL)
      {
        cerr << "Error:  Attempt to delete a non-existent " <<
                "list element " << endl;
        return;
      }
      
      // remove p->next from the chain and then delete it.
      p->next = temp->next;
      delete temp;
    }
  }
  else
  {
    cerr << "Error: Attempt to remove an element from the " <<
            "empty list " << endl;
  }
}