//
// Course.cpp
//
// LECTURE 19
// DEMO 1
//
#include "StdAfx.h"

#include <iostream>
#include <string>

using namespace std;  //introduces namespace std
#include "Course.h"

Course::Course()
{
  numStudents = maxStudents = 0;
  studentList = NULL;
}

Course::Course(string theName,string theInstructor,int theCount)
{
  numStudents = maxStudents = 0;
  studentList = NULL;
  
  instructor = theInstructor;
  name = theName;
  
  if (theCount > 0)
  {
    studentList = new Student[theCount];
    if (studentList)
      maxStudents = theCount;
  }
}

// Copy constructor
Course::Course(Course &argCourse)
{
  duplicate(argCourse);
}


Course::~Course()
{
  cout << "In Course's destructor" << endl;
  if (studentList)
    delete [] studentList;
}


//
// The overloaded assignment operator also utilized the "duplicate"
// method defined below
//
Course &Course::operator= (Course &argCourse)
{
  duplicate(argCourse);
  return *this;
}

//
// The private method "duplicate" will duplicate the Course instance
// passed as an argument to our instance.  This is used by both the
// Copy constructor and the assignment operator
//
void Course::duplicate(Course &argCourse)
{
  maxStudents = argCourse.maxStudents;
  numStudents = argCourse.numStudents;
  name = argCourse.name;
  instructor = argCourse.instructor;
  
  studentList = new Student[maxStudents];
  for (int i=0; i<numStudents; i++)
    studentList[i] = argCourse.studentList[i];  
}


int Course::getStudentCount()
{
  return numStudents;
}

string Course::getCourseName()
{
  return name;
}

string Course::getInstructor()
{
  return instructor;
} 

void Course::setStudentCount(int count)
{
  numStudents = count;
}

void Course::setCourseName(string theName)
{
  name = theName;
}

void Course::setInstructor(string theInstructor)
{
  instructor = theInstructor;
}

bool Course::addStudent(Student &aStudent)
{
  if (numStudents >= maxStudents)
    return false;
    
  studentList[numStudents++] = aStudent;
  return true;
}

void Course::printList()
{
  cout << "Course listing for: " << name << endl;
  cout << "Instructor:         " << instructor << endl;
  cout << "Max enrollment:     " << maxStudents << endl;
  cout << "Current enrollment: " << numStudents << endl;
  cout << "======================================================= " << endl;
  cout.width(15);
  cout << "NAME";
  cout.width(30);
  cout << "ADDRESS";
  cout.width(10);
  cout << "PHONE";
  cout << endl;
  
  for (int i=0; i<numStudents; i++)
  {
    cout.width(15);
    cout << studentList[i].getName();
    cout.width(30);
    cout << studentList[i].getAddr();
    cout.width(10);
    cout << studentList[i].getPhone();
    cout << endl;
  }
  
  cout << "------------------------------------------------------- " << endl;
}