/*
 *  Specialization.cpp
 */

#include "StdAfx.h"

#include <iostream>
#include <string>
using namespace std;  //introduces namespace std

// A generic template to compare to parameters of the same type
template<class aType> bool isLessThan(aType arg1,aType arg2)
{
  return arg1 < arg2;
}

// Handle the special case of character pointers
//bool isLessThan(char *str1,char *str2)
//{
//  return (strcmp(str1,str2) < 0);
//}

int main()
{	
    string str1 = "Test1";
    string str2 = "Test2";
    
    // Show that template work with MyString class
    if (isLessThan(str1,str2))
      cout << str1 << " is less than " << str2 << endl;
    else
      cout << str1 << " is greater than " << str2 << endl;
      

   // How about char * types?
   char *cstr1,*cstr2;
   
   cstr1 = new char[50];
   cstr2 = new char[50];
   
   if (!cstr1 || !cstr2)
   {
     cerr << "Pointer allocation failed!" << endl;
     return -1;
   }
   
   strcpy(cstr1,"def");
   strcpy(cstr2,"abc");   

   cout << (int) cstr1 << endl << cstr1 << endl << (int) cstr2 << endl << cstr2 << endl;
    if (isLessThan(cstr1,cstr2))
      cout << cstr1 << " is less than " << cstr2 << endl;
    else
      cout << cstr1 << " is not less than " << cstr2 << endl;

    delete [] cstr1;
    delete [] cstr2;
    
	return 0;
}

