//
// INT.h
//
// Header file for the INT class
//
//

#include <utility>  // Pulls in template based comparison operators
using namespace rel_ops;

class INT 
{
public:
  INT() {}
  INT(int argX) { value=argX; }
  
  int getValue() const { return value; }
  void setValue(int argValue) { value = argValue; }
  
  bool operator!();
  INT operator+();
  INT operator-();
  
private:
  int value;
};


// Overload operator>>
inline istream& operator>>(istream &is, INT &arg)
{
  int temp;
  is >> temp;
  arg.setValue(temp);
  return is;
}


// Overload operator<<
inline ostream& operator<<(ostream &os, INT &arg)
{
  os << arg.getValue();
  return os;
}



// Overload the operator+
inline INT operator+(INT &arg1,INT &arg2)
{
  INT temp(arg1.getValue() + arg2.getValue());
  return temp;
}


// Overload the operator-
inline INT operator-(INT &arg1,INT &arg2)
{
  INT temp(arg1.getValue() - arg2.getValue());
  return temp;
}


// Overload the operator*
inline INT operator*(INT &arg1,INT &arg2)
{
  INT temp(arg1.getValue() * arg2.getValue());
  return temp;
}


// Overload the operator/
inline INT operator/(INT &arg1,INT &arg2)
{
  INT temp(arg1.getValue()/arg2.getValue());
  return temp;
}


// Overload the operator==
inline bool operator==(const INT &arg1,const INT &arg2)
{
  return( arg1.getValue() == arg2.getValue() );
}


// Overload the operator<
inline bool operator<(const INT &arg1,const INT &arg2)
{
  return( arg1.getValue() < arg2.getValue() );
}


// Overload operator&&
inline bool operator&&(INT &arg1,INT &arg2)
{
  return( arg1.getValue() && arg2.getValue() );
}


// Overload operator||
inline bool operator||(INT &arg1,INT &arg2)
{
  return( arg1.getValue() || arg2.getValue() );
}

