/*
 *  FirstException.cpp
 *
 * LECTURE 15
 * DEMO 1
 */
#include "StdAfx.h"

#include <iostream>

using namespace std;  //introduces namespace std

// Error codes
enum MathErr {
  noErr,
  divByZero,
  genericOverflow
} ;

// divide function
float divide(float numerator,float denominator)
{
  if (denominator == 0)
    throw divByZero;
  return numerator/denominator;
}

// Test out exceptions!
int main()
{	
	try{
	  cout << "5 / 2 is " << divide(5,2) << endl;
	  cout << "2 / 0 is " << divide(2,0) << endl;
	  cout << "4 / 1 is " << divide(4,1) << endl;
	}
	catch(MathErr x)
	{
      if (x == divByZero)
        cout << "Caught Divide by Zero error! " << endl;
      else
        cout << "Generic error caught! " << endl;
	}
	
	cout << "All done... " << endl;
	
	return 0;
}

