//
// Number.h
//
// LECTURE 5
// DEMO 5
//

#include <iostream>
using namespace std;

#include <string.h>

class Number
{
public:
  
  Number();
  Number(int initValue);
  
  void setBase(int);
  int getBase();
  
  void setValue(int);
  int getValue() const;
  string getValueStr();
  
public:  // Operator overloads
  int operator+() const;
  string operator~();
  
private:
  long theValue;
  int base;
};

inline Number operator+ (const Number &num1, const Number &num2)
{
  // This is somewhat cheating.  Let's retrieve the raw values using
  // operator+ (we can't access the Value directly--we're defined 
  // outside the class) and then add them, stuffing the result in our
  // temporary Number.
  Number temp((+num1) + (+num2));
  return temp;
}