//
// Number.cpp
//
// LECTURE 5
// DEMO 4
//
#include "StdAfx.h"

#include <iostream>
#include <sstream>
using namespace std;

#include "Number.h"

//
// Here is the default constructor
//
Number::Number()
{
  theValue = 0;
  base = 10;
}


//
// This constructor takes an integer as an argument
//
Number::Number(int initValue)
{
  theValue = initValue;
  base = 10;
}


//
// printValue will return a string containing the value
//
string Number::getValueStr()
{
  ostringstream oss;
  
  if (base == 10)
  {
      oss << theValue;
      return oss.str();
  }
  
  oss << "Unknown";
  return oss.str();
}


//
// setValue takes a new value to store in our number
//
void Number::setValue(int arg)
{
  theValue = arg;
}


//
// getValue just returns the stored value
//
int Number::getValue()
{
  return theValue;
}


//
// Here come the operator overloads
//
int Number::operator+()
{
  return getValue();
}

string Number::operator~()
{
  return getValueStr();
}