//
// CoolArray.h
//
// Definition (& implementation) of the CoolArray class
//
// CS213 Fall 2002
// Assignment #9
//

#ifndef _COOL_ARRAY_H
#define _COOL_ARRAY_H

#include <string>

//
// A quick enum for some of our error codes
//
enum CoolArrayError
{
	kNoError = 0,
	kBadIndex,
	kNoMemory
};


//
// The CoolArrayException class is used for throwing exceptions
// related to CoolArray
//
class CoolArrayException
{
public:
	CoolArrayException(CoolArrayError err,string msg,int index):
	  caErr(err),caMsg(msg),caIndex(index)
	{}

	CoolArrayError getError()
	{
		return caErr;
	}

	string getMessage()
	{
		return caMsg;
	}

	int getIndex()
	{
		return caIndex;
	}


private:
	CoolArrayError caErr;
	string caMsg;
	int caIndex;
};

//
// CoolArray class
//
template <class T, int size>
class CoolArray
{
public:
	CoolArray();					// Constructor
	~CoolArray();					// Destructor

	T &operator[](int i);			// array index operator

private:
	void growStorage(int newSize);	// internal routine for growing
									// storage

	T staticStorage[size];			// initial static storage
	T *storage;						// main storage pointer
	int allocatedSize;				// current size of allocated
									// memory (static or dynamic)
};

//
// The CoolArray constructor sets our storage pointer to point
// at the initial statically allocated space and sets our 
// allocated size member variable equal to the initial statically
// allocated size
//
template <class T,int size>
CoolArray<T,size>::CoolArray()
{
	storage = &staticStorage[0];
	allocatedSize = size;
}

//
// The Cool Array destructor deletes any dynamically allocated
// memory present
//
template <class T,int size>
CoolArray<T,size>::~CoolArray()
{
	// Only attempt to delete dynamically allocated memory
	// if the allocated size is not the same as the originally
	// specified static size
	if (allocatedSize != size)
		delete [] storage;
}


//
// The array index operator overload either returns a reference to 
// the requested element or grows storage to allow an element at the 
// requested index.  If the index is negative, an exception is
// thrown
//
template <class T,int size>
T &CoolArray<T,size>::operator[] (int index)
{
  if (index < 0)
	  throw CoolArrayException(kBadIndex,
				"Negative index not allowed",index);

  if (index >= allocatedSize)
  {
	// Need to grow!  Call growStorage.  If new memory cannot
	// be allocated, growStorage will have thrown an exception.
	growStorage(index);
  }

  // Now, return the element
  return storage[index];
}
#endif 


//
// growStorage() needs to make sure there is enough room in 
// the array for the index requested.
//
template <class T,int size>
void CoolArray<T,size>::growStorage(int index)
{
	T *newStorage;
	
	try {
		newStorage = new T[index+1];
	}
	catch(bad_alloc)
	{
		throw CoolArrayException(kNoMemory,"Can't grow array",index);
	}

	if (newStorage == NULL)
		throw CoolArrayException(kNoMemory,"Can't grow array",index);

	//
	// If we get here, we were able to grow memory.  Copy the 
	// old contents to the new
	//

	for (int i=0; i<allocatedSize; i++)
		newStorage[i] = storage[i];

	//
	// Next, delete the old storage--only if it was dynamically
	// allocated
	//
	if (allocatedSize != size)
		delete [] storage;

	//
	// Now, point storage at the new storage
	//
	storage = newStorage;

	//
	// Finally, note the new allocated size
	//
	allocatedSize = index+1;

	// We're done!
}