//
// MenuObject.h
//
// CS213 Fall 2002
// Assignment #5
//

#ifndef _MENU_OBJECT_H
#define _MENU_OBJECT_H

#include <string>

class MenuObject
{
public:
	// Default constructor provides useful default values for the 
	// private fields
	MenuObject()
	{
		parent = NULL;
		name = "";
	}

	// The constructor which takes arguments shall have those arguments
	// applied to the appropriate private fields
	MenuObject(string theName,MenuObject *theParent)
	{
		name = theName;
		parent = theParent;
	}

	// declare select() and display() as pure virtual... they MUST be
	// overidden in any derived class.
	virtual void select() = 0;
	virtual void display() = 0;

	// Here come the simple setters and getters
	void setParent(MenuObject *theParent)
	{
		parent = theParent;
	}

	MenuObject *getParent()
	{
		return parent;
	}

	void setName(string theName)
	{
		name = theName;
	}

	string getName()
	{
		return name;
	}

private:
	MenuObject *parent;
	string name;
};


#endif
