//
// Menu.h
//
// CS213 Fall 2002
// Assignment #5
//

#ifndef _MENU_H
#define _MENU_H

#include "MenuObject.h"

class Menu : public MenuObject
{
public:
	// Default constructor calls MenuObject's default constructor
	// and then sets private data (to Menu) appropriately.  
	Menu() : MenuObject()
	{
		maxSize = numItems = 0;
		itemArray = NULL;
	}
	
	// The constructor which takes parameters passes the appropriate 
	// parameters to the MenuObject constructor and then allocates 
	// space for the internal itemArray based on the size parameter
	// passed
	Menu(string theName,MenuObject *theParent,int theSize):
		MenuObject(theName,theParent)
	{
		maxSize = numItems = 0;
		itemArray = NULL;
		
		if (theSize > 0)
		{
			itemArray = new MenuObject *[theSize];
			if (itemArray)
			{
				maxSize = theSize;
			}	
		}
	}

	// The destructor should free memory if it was allocated
	~Menu()
	{
		if (itemArray)
			delete [] itemArray;
	}


	// We must override select() and display()
	void select();
	void display();

	// processMenuChoice() allows the user to enter data (make choices)
	void processMenuChoice();

	// The following routines are provided for list (menu item) 
	//  manipulation.
	bool addItem(MenuObject *item);
	bool removeItem(int index);
	bool insertItem(MenuObject *item,int beforeIndex);

private:
	int maxSize;
	int numItems;
	MenuObject **itemArray;
};

#endif