//
// Menu.cpp
//
// CS213 Fall 2002
// Assignment #5
//

#include "StdAfx.h"

#include <iostream>

using namespace std;

#include "Menu.h"

//
// Menu::select() prints out all items in the current menu and provides
// the additional choices to quit and to return to the previous menu.
void Menu::select()
{
  cout << "MENU: " << getName() << endl;
  for (int i=0; i<numItems; i++)
  {
	  cout << i+1 << ". ";
	  (itemArray[i])->display();
	  cout << endl;
  }

  cout << numItems+1 << ". Quit." << endl;
  if (getParent())
	  cout << numItems+2 << ". Previous. " << endl;

  processMenuChoice();
}

//
// When displaying a menu by its name, display the name with a trailing
// asterisk so the user can tell this name is a menu.
void Menu::display()
{
	cout << getName() << "*";
}


//
// Menu::processMenuChoice handles the actual input of data and takes
// action based on the item entered.
//
void Menu::processMenuChoice()
{
	int choice;
	cout << "Please enter your choice: ";

	cin >> choice;

	while ((choice < 0) || (choice > numItems+2))
	{
		cout << "Invalid number, please enter your choice: ";
		cin >> choice;
	}

	choice--;

	if (choice == numItems)
		return;

	if (choice > numItems)
	{
		(getParent())->select();
		return;
	}

	(itemArray[choice])->select();
	return;
}


bool Menu::addItem(MenuObject *item)
{
  if (numItems < maxSize)
  {
	  itemArray[numItems++] = item;
	  return true;
  }
	
  return false;
}


bool Menu::insertItem(MenuObject *item,int beforeIndex)
{
  if (numItems >= maxSize)
	  return false;

  for (int i=numItems; i>beforeIndex; i--)
	itemArray[i] = itemArray[i-1];
  
  itemArray[beforeIndex] =item;
  numItems++;

  return true;
}


bool Menu::removeItem(int index)
{
  if ((index > 0) && (index <numItems))
  {
	for (int i=index; i < numItems; i++)
		itemArray[i] = itemArray[i+1];

	numItems--;
	return true;
  }

  return false;
}
