// Project:			Fixed Length Linked List
// Source File:		Tester.cpp
// Author:			James Ezick
// Creation Date:	February 27, 1999
//
// Description:
// This file serves as the test program for the methods of class
// List.  It illustrates list handling and iteration.
//

#include "list.h"
#include <iostream>
using namespace std;

void main()
{
	List m;

	m.AddTail(new element_t('a'));
	m.AddTail(new element_t('b'));
	m.AddTail(new element_t('c'));
	m.Insert(new element_t('z'),2);
	m.AddHead(new element_t('p'));
	m.Insert(new element_t('r'),5);

	m.Insert(new element_t('s'),5);
	m.Insert(new element_t('w'),2);
	m.AddTail(new element_t('h'));

	cout << m.GetLength() << ": " << m << endl;

	for(int i=1;i<=5;++i)
		m.Delete(i);

	cout << m.GetLength() << ": " << m << endl;

	m.AddHead(new element_t('x'));
	m.AddTail(new element_t('b'));
	m.Insert(new element_t('n'),5);

	m.Update(new element_t('v'),6);

	cout << m.GetLength() << ": " << m << endl;

	m.Swap(3,5);

	cout << m.GetLength() << ": " << m << endl;

	m.Sort();

	cout << m.GetLength() << ": " << m << endl;

	// Methods of printing (iterating)
	m.PrintList();

	for(m.First(); m.IsNotEnd(); ++m)
		m.Print();
	cout << endl;

	cout << m << endl;

	for(unsigned int j=0; j<m.GetLength(); ++j)
		cout << *(m[j]) << " ";
	cout << endl;

	// Reverse
	for(m.Last(); m.IsNotBeginning(); --m)
		m.Print();
	cout << endl << endl;

	// How you would iterate through while doing something
	for(m.First(); m.IsNotEnd(); ++m)
		m.Get()->DoSomething();
}