// Project:			Fixed Length Linked List
// Source File:		Element.h
// Author:			James Ezick
// Creation Date:	February 27, 1999
//
// Description:
// This class is a data element container for a static length linked list.  It
// is designed to emulate the function of template placeholder variable without
// the need to use templates.
//

#ifndef ELEMENT_T_H
#define ELEMENT_T_H

#include "utilities.h"
#include <iostream>
using std::ostream;

class element_t
{
public:
	element_t();
	element_t(Character InitialLetter);
	element_t(const element_t& ElementCopy);
	~element_t();

	Character GetValue() const;
	void SetValue(const Character NewLetter);
	void Print() const;
	void DoSomething() const;

	Boolean operator==(const element_t& TestElement) const;
	Boolean operator!=(const element_t& TestElement) const;
	element_t& operator=(const element_t& AssignElement);

	Boolean operator>(const element_t& TestElement) const;
	Boolean operator<(const element_t& TestElement) const;
	Boolean operator>=(const element_t& TestElement) const;
	Boolean operator<=(const element_t& TestElement) const;

friend ostream& operator<<(ostream& OutputStream, const element_t& OutputElement);

private:
	Character letter;
};

inline Character element_t::GetValue() const
{
	return letter;
}

inline void element_t::SetValue(const Character NewLetter)
{
	letter = NewLetter;
}

inline Boolean element_t::operator==(const element_t& TestElement) const
{
	return(letter==TestElement.letter);
}

inline Boolean element_t::operator!=(const element_t& TestElement) const
{
	return(letter!=TestElement.letter);
}

inline Boolean element_t::operator>(const element_t& TestElement) const
{
	return(letter > TestElement.letter);
}

inline Boolean element_t::operator<(const element_t& TestElement) const
{
	return(letter < TestElement.letter);
}

inline Boolean element_t::operator>=(const element_t& TestElement) const
{
	return(letter >= TestElement.letter);
}

inline Boolean element_t::operator<=(const element_t& TestElement) const
{
	return(letter <= TestElement.letter);
}

#endif