// Project:			Fixed Length Linked List
// Source File:		Element.cpp
// Author:			James Ezick
// Creation Date:	February 27, 1999
//
// Description:
// This class is a data element container for a static length linked list.  It
// is desinged to emulate the function of template placeholder variable without
// the need to use templates.
//

#include "element.h"

element_t::element_t()
{
	letter = '?';
}

element_t::element_t(Character InitialLetter)
{
	letter = InitialLetter;
}

element_t::element_t(const element_t& CopyElement)
{
	letter = CopyElement.letter;
}

element_t::~element_t()
{
}

void element_t::Print() const
{
	std::cout << "The letter is: " << letter << std::endl;
}

void element_t::DoSomething() const
{
	std::cout << "This is where " << letter << " does its thing." << std::endl;
}

element_t& element_t::operator=(const element_t& AssignElement)
{
	if(&AssignElement != this)
		letter = AssignElement.letter;
	return *this;
}

ostream& operator<<(ostream& OutputStream, const element_t& OutputElement)
{
	return OutputStream << OutputElement.letter;
}
