// James Ezick
// 9 February 1999
// Solution to Matrix Multiplication Problem - Assignment #1

#include<iostream>
#include<ios>
#include<fstream>
using namespace std;

#define MAX 20			// Maximum size of a matrix dimension

void error(const char* p, const char* p2 = "")
{
	cerr << p << " " << p2 << '\n';
	exit(0);
}

void main(int argc, char* argv[])
{
	if (argc != 3) error("wrong number of arguments");

	ifstream from(argv[1]);
	if(!from) error("cannot open input file", argv[1]);

	ofstream to(argv[2]);
	if(!to) error("cannor open output file.", argv[2]);

	int A[MAX][MAX];		// Matricies
	int B[MAX][MAX];
	int P[MAX][MAX];

	int NumberOfMatricies;	// Dimensions
	int DimA[2];
	int DimB[2];
	int DimP[2];

	int i,j,k;				// Loop variables

	from >> NumberOfMatricies;
	from >> DimP[0];
	from >> DimP[1];

	for(i=0; i<DimP[0]; ++i)		// Read first matrix into product
		for(j=0; j<DimP[1]; ++j)
			from >> P[i][j];

	for(int n=NumberOfMatricies; n>1; --n)  // Loop through matricies
	{
		DimA[0] = DimP[0];		// Move product to A
		DimA[1] = DimP[1];
		for(i=0; i<DimP[0]; ++i)
			for(j=0; j<DimP[1]; ++j)
				A[i][j] = P[i][j];

		from >> DimB[0];		// Move new matrix to B
		from >> DimB[1];
		for(i=0; i<DimB[0]; ++i)
			for(j=0; j<DimB[1]; ++j)
				from >> B[i][j];

		DimP[0] = DimA[0];		// P = A*B
		DimP[1] = DimB[1];
		if(DimA[1] != DimB[0]) error("dimension mismatch");
		for(i=0; i<DimA[0]; ++i)
			for(j=0; j<DimB[1]; ++j)
			{
				P[i][j] = 0;
				for(k=0; k<DimA[1]; ++k)
					P[i][j] += A[i][k]*B[k][j];
			}
	}

	to << 1 << endl;	// Write the output
	to << DimP[0] << " " << DimP[1] << endl;
	for(i=0; i<DimP[0]; ++i)
	{
		for(j=0; j<DimP[1]; ++j)
			to << P[i][j] << " ";
		to << endl;
	}	
	
	if(!to) error("something strange happened");  // Report result
	else 
	{
		cout << "Read input from " << argv[1] << ". " << endl;
		cout << "Multiplied " << NumberOfMatricies << " matricies." << endl;
		cout << "Output written to " << argv[2] << ". " << endl;
	}
}