// James Ezick
// 9 February 1999
// Solution to 3SAT Problem - Assignment #1

#include <iostream>
#include <cmath>
using namespace std;

#define NUMBER_OF_CLAUSES 20
#define VARIABLES_PER_CLAUSE 3  // 3-SAT
#define NUMBER_OF_VARIABLES 15  // Max is 16

void error(const char* p, const char* p2 = "")
{
	cerr << p << " " << p2 << '\n';
	exit(0);
}

bool Extract(unsigned short int TA, int Var)  // Get an assignment
{
	return ((TA>>(Var-1))%2 == 1);
}

void PrintTA(unsigned short int TA)  // Print a truth assignment
{
	for(int i=1; i<=NUMBER_OF_VARIABLES; ++i)
	{
		cout << i << ":";
		if(Extract(TA,i)) cout << "t ";
		else cout << "f ";
	}
	cout << endl;
}

bool CheckClause(int F[VARIABLES_PER_CLAUSE], unsigned short int TA)
{
	bool S = false;
	for(int i=0; i<VARIABLES_PER_CLAUSE && !S; ++i)  // 3 variables per clause
	{
		S = (F[i]>0 && Extract(TA, abs(F[i]))) || (F[i]<0 && !Extract(TA, abs(F[i])));
	}
	return S;
}

void main() 
{
	cout << "Formula?: ";

	int clauses = 0;
	int Formula[NUMBER_OF_CLAUSES][VARIABLES_PER_CLAUSE];

	while(cin.peek() != '\n')  // Parse the formula
	{
		while(cin.peek() == ' ') cin.get();  // eat whitespaces
		if(cin.get() != '(') error("ill formed formula");
		for(int i=0; i<VARIABLES_PER_CLAUSE; ++i)
			cin >> Formula[clauses][i];
		if(cin.get() != ')') error("ill formed formula");
		while(cin.peek() == ' ') cin.get();
		++clauses;
	}
	
	bool SAT = false;  // Result
	for(unsigned short int TruthAssignment=0; 
		(TruthAssignment<pow(2,NUMBER_OF_VARIABLES))  && !SAT; 
		++TruthAssignment)  // loop through all truth assignments
	{
		SAT = true;
		for(int clause=0; clause<clauses && SAT; ++clause)
			SAT = CheckClause(Formula[clause], TruthAssignment);
	}

	if(SAT)		// Report the result
	{
		cout << "Satisfiable. ";
		PrintTA(TruthAssignment);
	}
	else
		cout << "Unsatisfiable. ";
}


