#include <iostream>

/* This file demostrates the difference between
 * passing an argument to function by value or
 * by reference.
 */

class Foo
{
   public:
      Foo(int x): x(x) {}
      int x;
};

void addIntByVal(int);
void addFooByVal(Foo);
void addIntByRef(int*);
void addFooByRef(Foo*);

int main()
{
   using namespace std;

   int x = 5;
   Foo foo(5);

   cout << "x is: " << x << endl;
   cout << "foo.x is: " << foo.x << endl;

   cout << "calling addIntByVal" << endl;
   addIntByVal(x);
   cout << "x is now: " << x << endl;

   cout << "calling addIntByRef" << endl;
   addIntByRef(&x);
   cout << "x is now: " << x << endl;

   cout << "calling addFooByVal" << endl;
   addFooByVal(foo);
   cout << "foo.x is now: " << foo.x << endl;

   cout << "calling addFooByRef" << endl;
   addFooByRef(&foo);
   cout << "foo.x is now: " << foo.x << endl;

   return 0;
}

void addIntByVal(int x) { x++; }
void addIntByRef(int* px) { (*px)++; }
void addFooByVal(Foo foo) { foo.x++; }
void addFooByRef(Foo* pFoo) { pFoo->x++; }

