/* 
 * This is a demostration of how various constructs are
 * declared in C++.
 */

class Foo
{
   public:
      Foo() {}
      Foo(int x, int y): x(x), y(y) {}

   private:
      int x,y;
};

int main()
{
   // allocating on stack
   int x;
   Foo foo(1,2);

   // allocating on heap
   int* y = new int;
   Foo* bar = new Foo(1,2);

   /*
    * when finished using things allocated on
    * the heap, whether ints, chars, or objects,
    * remember to free the memory. It is good
    * practice to set the pointer to 0 after deletion
    * so you do not accidentally delete the same pointer
    * twice, which may crash your program.
    */
   delete y;
   y = 0;
   delete bar;
   bar = 0;

   // array on stack
   int intsOnStack[5];
   Foo foosOnStack[5];

   // array on heap
   int* intsOnHeap = new int[5];
   Foo* foosOnHeap = new Foo[5];  // this requires that Foo has a constructor
                                  // that takes no arguments
                                  
   // again, remember to free memory when done
   delete intsOnHeap;
   intsOnHeap = 0;
   delete[] foosOnHeap; // use delete[] for arrays of objects
   foosOnHeap = 0;

   /* what if you want an array of objects, but
    * it doees not have a constructor that take no aruments?
    * let's pretend Foo only has the constructor for (int*int)
    */
   Foo** argFoosOnHeap = new Foo*[6];
   for(int i = 0; i < 6; i++)
      argFoosOnHeap[i] = new Foo(i, i);

   // and to delete this array,
   for(int i = 0; i < 6; i++)
   {
      delete argFoosOnHeap[i];
      argFoosOnHeap[i] = 0;
   }
   delete argFoosOnHeap;
   argFoosOnHeap = 0;

   /* quiz, tricky quest, or whatever you would call it:
    * what does the following code mean?
    * does it cause any memory leaks if left along like that?
    * what's the type of "tricky"?
    */
   Foo* tricky[10];

}
