#include <iostream>
#include "Animal.h"

/*
 * The broken animal kingdom.
 * See version 6 for correction.
 */

using namespace std;

Mammal::Mammal(char* name):
   Animal(name)
{
   cout << name << " is now a mammal." << endl;
}

Mammal::~Mammal()
{
   cout << itsName << " is no longer a mammal." << endl;
}

Cow::Cow(char* name):
   Mammal(name)
{
   cout << name << " is now a cow." << endl;
}

Cow::~Cow()
{
   cout << itsName << " is no longer a cow." << endl;
}

void Cow::makeSound()
{
   cout << itsName << " moos." << endl;
}

Cat::Cat(char* name):
   Mammal(name)
{
   cout << name << " is now a cat." << endl;
}

Cat::~Cat()
{
   cout << itsName << " is no longer a cat." << endl;
}

void Cat::makeSound()
{
   cout << itsName << " meows." << endl;
}

Human::Human(char* name):
   Mammal(name)
{
   cout << name << " is now a person." << endl;
}

Human::~Human()
{
   cout << itsName << " is no longer a person." << endl;
}

void Human::makeSound()
{
   cout << itsName << " says, \"Hi!\"" << endl;
}

int main()
{
   Mammal* zoo[3];
   zoo[0] = new Cow("Moo");
   zoo[1] = new Cat("Snuggles");
   zoo[2] = new Human("Kenny"); // spectator, NOT on display.

   zoo[0]->makeSound();
   zoo[1]->makeSound();
   zoo[2]->makeSound();

   for(int i = 0; i < 3; i++)
      delete zoo[i];

   return 0;
}
