/**
 *  File: gba_video.h
 *  Probject: 212SP07 GBA Headers 
 *  Last Update: 11/29/07
 *  Description: video memory registers and definitions.
 */

#ifndef GBA_VIDEO_H
#define GBA_VIDEO_H
 
#include "gba_types.h"


/// Registers ///

#define FrontBuffer     ((u16*)0x6000000)
#define REG_DISPCNT     *(u16*)0x4000000
#define REG_VCOUNT      *(volatile u16*)0x4000006


/// Definitions ///

#define SCREEN_WIDTH    240
#define SCREEN_HEIGHT   160 

#define MODE_0          0x0
#define MODE_1          0x1
#define MODE_2          0x2
#define MODE_3          0x3
#define MODE_4          0x4
#define MODE_5          0x5

#define BG0_ENABLE      0x100
#define BG1_ENABLE      0x200
#define BG2_ENABLE      0x400
#define BG3_ENABLE      0x800
#define OBJ_ENABLE      0x1000

#define OBJ_MAP_2D      0x00
#define OBJ_MAP_1D      0x40

#define BackBuffer      0x10

#define H_BLANK_OAM     0x20

#define SetMode(mode)   REG_DISPCNT = (mode)

#define vsync()         while(REG_VCOUNT != 160);

#endif
