/**
 *  File: gba_types.h
 *  Probject: 212SP07 GBA Headers 
 *  Last Update: 11/29/07
 *  Description: type definitions.
 */

#ifndef GBA_TYPES_H
#define GBA_TYPES_H

typedef unsigned char   u8;
typedef unsigned short  u16;
typedef unsigned long   u32;

typedef signed char     s8;
typedef signed short    s16;
typedef signed long     s32;

typedef volatile s8     vs8;
typedef volatile s16    vs16;
typedef volatile s32    vs32;

#define INLINE static   inline

#define RGB(r,g,b)      ((u16)(r | (g<<5) | (b<<10)))

#endif
