package simple;

import java.io.PrintWriter;

/**
 * AST node for a binary operator.
 */
public class AstOperator extends Ast {

    private char operator;
    private Ast left, right;

    /**
     * @param operator the binary operator (+,-,*,/)
     * @param left the left operand
     * @param right the right operand
     */
    public AstOperator(char operator, Ast left, Ast right) {
        this.operator = operator;
        this.left = left;
        this.right = right;
    }

    @Override
    public void generate(PrintWriter out) {
        // TODO Auto-generated method stub
    }

    @Override
    public String toString() {
        return operator + "(" + left + "," + right + ")";
    }

}
