/**
 *  File: util.h
 *  Project: 212SP08 Assignment 2
 *  Description: utility functions.
 *
 */

#ifndef UTIL_H
#define UTIL_H

#include "gba/gba.h"
#include "defs.h"

namespace gbaUtil
{
  /** gbaUtil includes useful utility functions.
   */

  /** Returns the absolute value of a signed number.
   */
  s16 abs(s16 number);

  /** Returns the sign of a signed number.
   */
  s16 sign(s16 number);

  /** Returns the dimension of a sprite with size and shape.
   */
  Point spriteDimension(u16 size, u16 shape);

  /** Returns the dimension of the background with size.
   *  exclusively for text background.
   */
  Point backgroundDimension(u16 size);

  /** Copy the local sprites data in sprites to OAM_Mem
   *  from indices 0 to limit.
   */
  void copyOamLimited(OAMEntry* sprites, u16 limit);


  /*** Do not use the following members ***/

  const u16 spriteDimensionLookUp[12] = {
  // (shape << 2) + size
  0x33, 0x44, 0x55, 0x66,
  0x34, 0x35, 0x45, 0x56,
  0x43, 0x53, 0x54, 0x65
};

/* elements 4-7 are for rotation background */
  const u16 backgroundDimensionLookUp[8] = {
  // (type << 2) + size
  0x99, 0x98, 0x89, 0x99,
  0x77, 0x88, 0x99, 0xAA
};

  void copyOam(OAMEntry* sprites);

}

#endif

