/**
 *  File: util.cpp
 *  Project: 212SP08 Assignment 2
 *  Description: utility functions.
 *
 */

#include "util.h"

s16 gbaUtil::abs(s16 number) {
  return (number < 0)? -number : number;
}

s16 gbaUtil::sign(s16 number) {
    return (number < 0)? -1 : 1;
}

Point gbaUtil::spriteDimension(u16 size, u16 shape) {
   // look up indices and value
   size = size >> 14;
   shape = shape >> 14;
   u16 v = spriteDimensionLookUp[shape << 2 + size];
   u16 x = 1 << ((v&0xF0)>>4);
   u16 y = 1 << (v&0x0F);
   Point ret(x,y);
   return ret;
}

Point gbaUtil::backgroundDimension(u16 size) {
   // look up indices and value
   size = size >> 14;
   u16 v = backgroundDimensionLookUp[size];
   u16 x = 1 << ((v&0xF0)>>4);
   u16 y = 1 << (v&0x0F);
   Point ret(x,y);
   return ret;
}

void gbaUtil::copyOam(OAMEntry* sprites)
{
    copyOamLimited(sprites, 128);
}

void gbaUtil::copyOamLimited(OAMEntry* sprites, u16 limit)
{
    u16* pSprites;
    pSprites = (u16*)sprites;
    for(int i = 0; i < limit*4; i++)
    OAM_Mem[i] = pSprites[i];
}

