/**
 *  File: graphics.h
 *  Project: 212SP08 Assignment 2
 *  Description: decalaration of Graphics data and lengths.
 *
 */

#ifndef GRAPHICS_H
#define GRAPHICS_H

#include "gba/gba.h"

/** Graphics: All graphics data are initialized in this file.
 *  spriteData contains all sprite data that needs to be copied to
 *  object data memory. the length of the data is SPRITE_DATA_LENGTH.
 *  spritePalette contains all palette data that needs to be copied
 *  to object palette memory. the length of the data is
 *  SPRITE_PALETTE_LENGTH.
 *  tileData contains all tile data that needs to be copied to
 *  the char base block for the tile background. the length of the
 *  data is TILE_DATA_LENGTH.
 *  tilePalette contains all palette data for tiles. the length of
 *  the data is TILE_PALETTE_LENGTH.
 *
 */

#define SPRITE_DATA_LENGTH      32*28
#define TILE_DATA_LENGTH        32*2
#define SPRITE_PALETTE_LENGTH   6
#define TILE_PALETTE_LENGTH     7

/** graphics for sprites
 *  length: SPRITE_DATA_LENGTH
 *  1-8: normal mario
 *  9-16: walking mario
 *  17-24: jumping mario
 *  25-32: goomba
 *  33-40: goomba frame 2 (mirrored)
 *  41-48: mushroom
 *  49-56: ! block
 */
extern const u16 spriteData [];

/** graphics for tiles
 *  length: TILE_DATA_LENGTH
 *  0: sky
 *  1: brick
 */
extern const u16 tileData [];

/** palette for sprites
 *  length: SPRITE_PALETTE_LENGTH
 */
extern const u16 spritePalette [];

/** palette for tiles
 *  length: TILE_PALETTE_LENGTH
 */
extern const u16 tilePalette [];

#endif

