/**
 *  File: gba_mem.h
 *  Probject: 212SP07 GBA Headers
 *  Last Update: 11/29/07
 *  Description: GBA memory access registers and definitions.
 */

#ifndef GBA_MEM_H
#define GBA_MEM_H


/// Direct Memory Access ///

// Registers
#define REG_DMA3SAD     *(volatile unsigned int*)0x40000D4
#define REG_DMA3DAD     *(volatile unsigned int*)0x40000D8
#define REG_DMA3CNT     *(volatile unsigned int*)0x40000DC

// Definitions
#define DMA_ENABLE           0x80000000
#define DMA_TIMING_IMMEDIATE 0x00000000

#define DMA_16      0x00000000
#define DMA_32      0x04000000

#define DMA_32NOW   (DMA_ENABLE | DMA_TIMING_IMMEDIATE | DMA_32)
#define DMA_16NOW   (DMA_ENABLE | DMA_TIMING_IMMEDIATE | DMA_16)


/// EWRAM ///

#define EWRAM           ((u16*)0x02000000)
#define DATA_IN_EWRAM   __attribute__((section(".ewram")))
#define CODE_IN_EWRAM   __attribute__((section(".ewram"), long_call))

#endif

