/**
 *  File: gba_keys.h
 *  Probject: 212SP07 GBA Headers 
 *  Last Update: 11/29/07
 *  Description: definitions of input keys.
 */

#ifndef GBA_KEYS_H
#define GBA_KEYS_H 

#include "gba_types.h"

/// Registers ///

#define KEYS            *(volatile u16*)0x04000130

/// Definitions ///

#define KEY_A           0x001
#define KEY_B           0x002
#define KEY_SELECT      0x004
#define KEY_START       0x008
#define KEY_RIGHT       0x010
#define KEY_LEFT        0x020
#define KEY_UP          0x040
#define KEY_DOWN        0x080
#define KEY_R           0x100
#define KEY_L           0x200

#define keyDown(k)      (~KEYS & k)  

#endif
