/**
 *  File: game.h
 *  Project: 212SP08 Assignment 2
 *  Description: Declaration of game-speicfic classes.
 *
 */
#ifndef GAME_H
#define GAME_H

#include "gba/gba.h"
#include "sprite.h"
#include "background.h"
#include "map.h"
#include "util.h"
#include "defs.h"

class Mario : public Sprite {
  /** Mario is an extension of the Sprite class. It handles
   *  Mario-specific movements and setup.
   */
  private:
    u16 lives_;         /* number of lives */
    u16 state_;         /* state of mario */

  public:
    /** Create a Mario character.
     */
    Mario();

    /** constants for state */
    static const u16 WAIT = 0;
    static const u16 WALK = 1;
    static const u16 JUMP = 2;
    static const u16 DEAD = 3;

    /**
     */
    void walk(Direction direction);

    /** Mario jumps.
     *
     * Arugments
     *  u16 direction : the direction of the jump. Can only
     *                  be either East or West.
     *
     * Returns
     *  none
     */
    void jump(Direction direction);

    /** Mario dies.
     *
     * Arguments
     *  none
     *
     * Returns
     *  none
     */
    void die();

    void reset();

    void wait();

    void setDirection(Direction direction);

    /** Setters and Getters
     */
    u16 getLives();
    void addLives(u16 ups);
    u16 getState();
    void setState(u16 state);

};

class Game {
  /** Game handles all game logic. It is a singleton object.
   *  Should only be instantiated once.
   */
  private:
    static bool exists_;       /* whether Game object exists */
    Mario *mario_;      /* player */
    Sprite *goomba_;    /* the notorious Goomba! */
    Sprite *mushroom_;  /* 1-Up mushroom! */
    Sprite *exclamation_;  /* question mark brick */
    Background *bg_;    /* background */
    u16 counter_;       /* a frame-based-counter */

  public:
    /** Construct the game object.
     *  initialize the game.
     */
    Game();

    /** Deconstructor
     */
    ~Game();

    /** The game loop.
     *
     * Arguments
     *  none
     *
     * Returns
     *  u16 : the exit code.
     */
    u16 run();

    /** Display start page.
     *
     * Arguments
     *  none
     *
     * Returns
     *  none
     */
    void startPage();

    /** Display game over page.
     *
     * Arguments
     *  none
     *
     * Returns
     *  none
     */
    void gameOver();};

#endif
