/**
 *  File: game.cpp
 *  Project: 212SP08 Assignment 2
 *  Description: Game implementation.
 *
 */

#include "game.h"

using namespace gbaUtil;

//// Mario /////

/// Constructor ///
Mario::Mario() :
  Sprite(1, COLOR_256, 0, SIZE_16, SQUARE, 64<<FIXPT, 128<<FIXPT) {
    state_ = Mario::WAIT;
    lives_ = 3;
    setAcceleration(0,0);
    setSpeedCap(24,-1);
    setAnimation(1,1,2);
  }

void Mario::walk(Direction direction)
{
    switch (direction)
    {
        case East:  setAcceleration(3,0);
                    break;
        case West:  setAcceleration(-3,0);
    }
    setDirection(direction);
    setCycleDir(1);
}

void Mario::wait()
{
    setCurrentFrame(1);
    setAcceleration(0,0);
    setVelocity(0,0);
    setCycleDir(0);
}

void Mario::setDirection(Direction direction)
{
    if (direction == East)
    {
        Sprite::setDirection(East);
        setHFlip(false);
    }
    else
    {
        Sprite::setDirection(West);
        setHFlip(true);
    }
}


void Mario::jump(Direction direction)
{
    Point p = getVelocity();
    s16 v = abs(p.x);
    v = -46;
    setVelocity(p.x,v);
    setAcceleration(0,3);
    setDirection(direction);
    setCurrentFrame(17);
    setCycleDir(0);
}

void Mario::die()
{
    lives_--;
    setAcceleration(0,0);
    setVelocity(24,0);
    setVFlip(true);
}

void Mario::reset()
{
    wait();
    setDirection(West);
    setVFlip(false);
    setPosition(64<<FIXPT, 128<<FIXPT);
}

u16 Mario::getLives()
{
  return lives_;
}
void Mario::addLives(u16 ups)
{
    lives_ += ups;
}
u16 Mario::getState()
{
    return state_;
}
void Mario::setState(u16 state)
{
    state_ = state;
}

//// Game ////

bool Game::exists_ = false;

Game::Game() :
  mario_(new Mario()),
  counter_(0)
{
    SetMode(MODE_0 | OBJ_ENABLE | OBJ_MAP_1D | BG0_ENABLE);
    bg_ = new Background(8, 0, BG_COLOR_256);
    bg_->loadMap(map,MAP_WIDTH*MAP_HEIGHT);

    goomba_ = new Sprite(25, COLOR_256, 0, SIZE_16, SQUARE,
                            200<<FIXPT,128<<FIXPT);
    Point bgdim = bg_->getDimension();
    mushroom_ = new Sprite(41, COLOR_256, 0, SIZE_16, SQUARE,
                            144<<FIXPT,(bgdim.y-16)<<FIXPT);
    exclamation_ = new Sprite(49, COLOR_256, 0, SIZE_16, SQUARE,
                            144<<FIXPT,88<<FIXPT);
    exists_ = true;
}

Game::~Game()
{
    delete mario_;
    delete goomba_;
    delete mushroom_;
    delete exclamation_;
    delete bg_;
}

u16 Game::run()
{
    Sprite::draw();
    // initial setting
    goomba_->setVelocity(-10,0);
    goomba_->setAnimation(25,1,2);
    while(mario_->getLives() >= 0)
    {
        u16 state = mario_->getState();
        // special case: dead
        if (state == Mario::DEAD)
        {
            if (mario_->getPosition().y >> FIXPT >= 240)
                mario_->reset();
            else
                continue;
        }

        // state transition
        switch (state)
        {
            case Mario::WAIT:
            case Mario::WALK:
                if (keyDown(KEY_A))
                {
                    Direction dir = keyDown(KEY_LEFT)? West:
                                    keyDown(KEY_RIGHT)? East:
                                    mario_->getDirection();
                    mario_->jump(dir);
                    mario_->setState(Mario::JUMP);
                }
                else if (keyDown(KEY_RIGHT))
                {
                    mario_->walk(East);
                    mario_->setState(Mario::WALK);
                }
                else if (keyDown(KEY_LEFT))
                {
                    mario_->walk(West);
                    mario_->setState(Mario::WALK);
                } else
                {
                    mario_->wait();
                    mario_->setState(Mario::WAIT);
                }
                break;
            case Mario::JUMP:
                if (mario_->getPosition().y >> FIXPT >= 128)
                    mario_->setState(Mario::WAIT);
                if (keyDown(KEY_LEFT))
                    mario_->setDirection(West);
                else if (keyDown(KEY_RIGHT))
                    mario_->setDirection(East);
                break;
            case Mario::DEAD:
                break;
        }

        // sprite movement updates
        mario_->move();
        goomba_->move();
        mushroom_->move();
        if (!(counter_++ & 0x000C))
        {
            mario_->animate();
            goomba_->animate();
        }

        // collision detection against background
        // collision detection against sprites

        // draw
        Sprite::draw();
    }
}

void Game::startPage() {}

void Game::gameOver() {}

int main()
{
    Game *g = new Game();
    g->run();
    while(true){}
    return 0;
}
