/**
 *  File: defs.h
 *  Project: 212SP08 Assignment 2
 *  Description: project-specific definitions and constants.
 *
 */

#ifndef DEFS_H
#define DEFS_H

#include "gba/gba.h"

// directions
enum Direction
{
    North, South, West, East
};

// fixed point shift
#define FIXPT       4

// a Point represents a point in a 2D plane.
class Point
{
  public:
    s16 x;
    s16 y;

    Point();
    Point(s16 a, s16 b);
    Point clone();
    void plus(Point other);
    void plus(s16 a, s16 b);
    void neg();
};
#endif

