/**
 *  File: background.h
 *  Project: 212SP08 Assignment 2
 *  Description: Declaration of Background class
 *
 */
#ifndef BACKGROUND_H
#define BACKGROUND_H

#include "gba/gba.h"
#include "defs.h"
#include "util.h"
#include "graphics.h"

class Background {

  /** Background is a singleton object. It should not be
   *  instantiated more than once. This class initializes and
   *  handles the operations of the tiled background mode.
   *  This class assumes only one layer of background.
   */

   public:
     /** Initialize the background with the following default
      *  attributes:
      *  mode : 0
      *  background : 0
      *  size : 512x256 (text background)
      *  pirority : 0
      *  mosaic : no
      *  offsets : 0
      *
      * Arguments
      *  u16 sbb : the index of ScreenBaseBlock to be used
      *  u16 cbb : the index of CharBaseBlock to be used
      *  u16 colorDepth : color depth for this background
      *                   must be BG_COLOR_XXX defined in gba_bg.h.
      *
      * Returns
      *  none
      */
     Background(u16 sbb, u16 cbb, u16 colorDepth);

     /** Deconstructor.
      *  should clear all data in SBB and CBB in use
      */
     ~Background();

     /** Load map on to the ScreenBB
      *
      * Arguments
      *  u16* map : the map array.
      *  u16 length : the length of the array.
      *
      * Returns
      *  none
      */
     void loadMap(const u16* map, u16 length);

     /** Get the type of tile at the pixel indicated.
      *
      * Arguments
      *  Point* location : the location of pixel on screen.
      *                    (NOT fixed point)
      *
      * Returns
      *  u16 : the tile number at location.
               returns -1 when location is out of the
      *        screen.
      */
     u16 getTile(Point location);

     /** Set the type of tile at the pixel indicated
      *
      * Arguments
      *  vector* location : the location of pixel on screen.
      *  u16 type : the tile number
      *
      * Returns
      *  none
      */
     void setTile(Point location, u16 type);

     /** Scroll the background in direction indicated.
      *  if wrapAround is on, the background will wrap around
      *  when it scrolls to the end. If not, it will do nothing.
      *
      * Arguments
      *  Direction direction : the direction to scroll.
      *  u16 pixel : the number of pixels to be scrolled over.
      *
      * Returns
      *  bool : false if reaches the end of the background.
      *         always true if wrapAround is on.
      */
     bool scroll(Direction direction, u16 pixel);

     /** Setters and Getters
       * For specs see comments above.
       */
     /** Returns the dimension (in pixels) of the background.
      */
     Point getDimension();

     private:

     //
     // DECLARE PRIVATE VARIABLES AS NEEDED
     //

};

#endif
