#ifndef SPRITE_H
#define SPRITE_H

#include "gba.h"
#include "Sprites.h"

namespace spritespace
{

 const u16 xMask = 0x01FF;
 const u16 yMask = 0x00FF;

 extern OAMEntry* sprites;

 enum SpriteType { BALL, PADDLE, ALPHANUM };

 class Sprite
 {

  public:

     /*
      * create a new sprite
      * must be BALL or PADDLE
      */
     Sprite(SpriteType);

     /*
      * create a new sprite
      * 0 <= i <= 9
      */
     Sprite(int i);

     //set x and y coordinates of sprite
     void setX(int);
     void setY(int);

     // 0 <= i <= 9, sprite must already be ALPHANUM
     void setNum(int);

  private:
     static int nextId;
     int itsId;
     SpriteType itsType;

 };

 //copy sprite and pallette data into memory
 void initSprites();

 void copyOAM();

}

#endif

