#include "Sprite.h"


OAMEntry* spritespace::sprites = new OAMEntry[128];

int spritespace::Sprite::nextId = 0;




//creates a new sprite of type s
spritespace::Sprite::Sprite(SpriteType type):
  itsType(type), itsId(nextId++)
{
 switch (type)
 {
   case BALL:
     sprites[itsId].attribute0 = COLOR_16 | SQUARE;
     sprites[itsId].attribute1 = SIZE_8;
     sprites[itsId].attribute2 = 1;
     type = BALL;
     break;

   case PADDLE:
     sprites[itsId].attribute0 = COLOR_16 | TALL;
     sprites[itsId].attribute0 = SIZE_16;
     sprites[itsId].attribute2 = 2;
     type = PADDLE;
     break;

   default:
     break;
 }
}

//creates a new sprite displaying i
spritespace::Sprite::Sprite(int i):
  itsType(ALPHANUM), itsId(nextId++)
{
  sprites[itsId].attribute0 = COLOR_16 | SQUARE;
  sprites[itsId].attribute1 = SIZE_8;
  sprites[itsId].attribute2 = 6+i;
}

//sets the x-value of sprite on the screen
void spritespace::Sprite::setX(int xVal)
{
 switch(itsType)
 {
   case BALL:
   case ALPHANUM:
     sprites[itsId].attribute1 = SIZE_8 | (xMask & xVal);
     break;

   case PADDLE:
     sprites[itsId].attribute1 = SIZE_16 | (xMask & xVal);
     break;

   default:
     break;
 }
}

//sets y value of sprite on the screen
void spritespace::Sprite::setY(int yVal)
{
 switch(itsType)
 {
   case BALL:
   case ALPHANUM:
     sprites[itsId].attribute0 = COLOR_16 | SQUARE | (yMask &  yVal);
     break;

   case PADDLE:
     sprites[itsId].attribute0 = COLOR_16 | TALL | (yMask & yVal);
     break;

   default:
     break;

 }
}

//changes the displayed number of the sprite
void spritespace::Sprite::setNum(int num)
{
  if (itsType == ALPHANUM && num < 10 && num >= 0)
     sprites[itsId].attribute2 = 6+num;
}

//copies sprite data into memory and initializes sprites
void spritespace::initSprites()
{

 //transfer palette data into memory (16 colors)
 //only 5 are used in this sprite set
 for(int i = 0; i < 5; i++){
   OBJ_PaletteMem[i] = sprite_palette[i];
 }

 //transfer ball sprite into memory (2x8)
 // The first slot of (32 bytes) OAM_Data
 // is reserved, so we start after 
 // the first slot
 // 16 transfers, 16 bits a transfer
 for(int i = 16; i < 32; i++) {
   OAM_Data[i] = ball[i-16];
 }
 // Transfer paddle sprite into memory.
 // Since the paddles are all white,
 // the same block of four white pixels
 // is copied to the right dimensions of
 // the paddle
 for (int i = 32; i < 96; i++) {
   OAM_Data[i] = paddle[0];
 }
 // transfer numbers (0-9) into memory   ()
 for (int i = 96; i < 256; i++) {
   OAM_Data[i] = numbers[i-96];
 }
 // transfer letters (A-Z) into memory   ()
 u16* temp_alphabet;
 temp_alphabet = (u16*)alphabet;

 for (int i = 256; i < (256 + (26*32)); i++) {
   OAM_Data[i] = temp_alphabet[i-256];
 }

}

//copies sprite data to OAM memory
void spritespace::copyOAM()
{
 u16* pSprites;
 pSprites = (u16*)sprites;
 for(int i = 0; i < 128*4; i++)
   OAM_Mem[i] = pSprites[i];
}
