/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cs.sam.ui;

import edu.cornell.cs.sam.core.AssemblerException;
import edu.cornell.cs.sam.core.Memory;
import edu.cornell.cs.sam.core.Processor;
import edu.cornell.cs.sam.core.Program;
import edu.cornell.cs.sam.core.SamAssembler;
import edu.cornell.cs.sam.core.Sys;
import edu.cornell.cs.sam.core.SystemException;
import edu.cornell.cs.sam.core.Video;
import edu.cornell.cs.sam.utils.ProgramState;
import edu.cornell.cs.sam.utils.SamThread;
import edu.cornell.cs.sam.utils.XMLUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Queue;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestScript {
    protected Sys sys;
    protected Processor proc;
    protected Memory mem;
    protected List<String> testNames = new ArrayList<String>();
    protected List<Test> tests = new ArrayList<Test>();
    protected File sourceFile = null;
    protected boolean autoSort = false;

    public TestScript() {
        this.sys = new Sys();
        this.proc = this.sys.cpu();
        this.mem = this.sys.mem();
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public void setSourceFile(File file) {
        this.sourceFile = file;
    }

    public void load(InputStream toParse) throws TestScriptException {
        Document doc;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(toParse);
        }
        catch (ParserConfigurationException e) {
            throw new TestScriptException("File Parse Error");
        }
        catch (IOException e) {
            throw new TestScriptException("File Parse Error");
        }
        catch (SAXException e) {
            throw new TestScriptException("File Parse Error");
        }
        NodeList l = doc.getElementsByTagName("testscript");
        if (l.getLength() != 1) {
            throw new TestScriptException("Invalid File");
        }
        Element root = (Element)l.item(0);
        if (root.getAttribute("version") == null || !root.getAttribute("version").equals("1.0")) {
            throw new TestScriptException("Incorrect Version in Test Script");
        }
        l = root.getElementsByTagName("test");
        for (int i = 0; i < l.getLength(); ++i) {
            Test t = this.processTest((Element)l.item(i));
            this.addTest(t);
        }
    }

    protected Test processTest(Element e) throws TestScriptException {
        String fileName = e.getAttribute("filename");
        if (fileName == null) {
            throw new TestScriptException("Invalid filename for test");
        }
        Test t = new Test(fileName);
        t.setScriptFile(this);
        NodeList l = e.getElementsByTagName("io");
        if (l.getLength() == 0) {
            throw new TestScriptException("Each test must have a return value");
        }
        for (int i = 0; i < l.getLength(); ++i) {
            Test.DataType data;
            String typeParam;
            String classParam;
            block35: {
                String dataString;
                block33: {
                    block34: {
                        Element io = (Element)l.item(i);
                        classParam = io.getAttribute("class");
                        typeParam = io.getAttribute("type");
                        if (classParam == null || typeParam == null) {
                            throw new TestScriptException("Each io object must have a class and type");
                        }
                        NodeList list = io.getChildNodes();
                        if (list.getLength() > 1 || list.item(0) == null || list.item(0).getNodeType() != 3) {
                            throw new TestScriptException("Each IO object must have a value");
                        }
                        dataString = ((Text)list.item(0)).getData();
                        if (typeParam.equals("int")) {
                            try {
                                data = new Test.INT(Integer.parseInt(dataString));
                            }
                            catch (NumberFormatException e1) {
                                throw new TestScriptException("Error parsing integer data");
                            }
                        }
                        if (typeParam.equals("ma")) {
                            try {
                                data = new Test.MA(Integer.parseInt(dataString));
                            }
                            catch (NumberFormatException e1) {
                                throw new TestScriptException("Error parsing integer data");
                            }
                        }
                        if (typeParam.equals("pa")) {
                            try {
                                data = new Test.PA(Integer.parseInt(dataString));
                            }
                            catch (NumberFormatException e1) {
                                throw new TestScriptException("Error parsing integer data");
                            }
                        }
                        if (typeParam.equals("float")) {
                            try {
                                data = new Test.FLOAT(Float.parseFloat(dataString));
                            }
                            catch (NumberFormatException e1) {
                                throw new TestScriptException("Error parsing float data");
                            }
                        }
                        if (!typeParam.equals("char")) break block33;
                        if (dataString == null || dataString.length() != 1 && dataString.length() != 2) {
                            throw new TestScriptException("One-letter String required for Characters");
                        }
                        if (dataString.length() == 2 && dataString.charAt(0) != '\\') {
                            throw new TestScriptException("Two character Character strings must be escape sequences");
                        }
                        if (dataString.length() != 2) break block34;
                        switch (dataString.charAt(1)) {
                            case 'n': {
                                data = new Test.CH('\n');
                                break block35;
                            }
                            case 't': {
                                data = new Test.CH('\t');
                                break block35;
                            }
                            case 'r': {
                                data = new Test.CH('\r');
                                break block35;
                            }
                            case '\\': {
                                data = new Test.CH('\\');
                                break block35;
                            }
                            default: {
                                throw new TestScriptException("Invalid Escape Expression");
                            }
                        }
                    }
                    data = new Test.CH(dataString.charAt(0));
                    break block35;
                }
                if (typeParam.equals("string")) {
                    data = new Test.STR(dataString);
                } else {
                    throw new TestScriptException("IO objects must be of type int, char, or float");
                }
            }
            if (classParam.equals("return") && t.getReturnValue() != null) {
                throw new TestScriptException("Only one return value per test allowed");
            }
            if (classParam.equals("return") && typeParam.equals("string")) {
                throw new TestScriptException("String return values are not allowed");
            }
            if (classParam.equals("return")) {
                t.setReturnValue(data);
                continue;
            }
            if (classParam.equals("read")) {
                t.addToRead(data);
                continue;
            }
            if (classParam.equals("write")) {
                t.addToWrite(data);
                continue;
            }
            throw new TestScriptException("IO objects must be of class return, read, or write");
        }
        if (t.getReturnValue() == null) {
            throw new TestScriptException("All test scripts must have a return value specified");
        }
        return t;
    }

    public boolean isAutoSortingEnabled() {
        return this.autoSort;
    }

    public void enableAutoSorting(boolean sort) {
        this.autoSort = sort;
    }

    public void save(File toSave) throws TestScriptException {
        Document xmlDoc;
        try {
            xmlDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new TestScriptException("Error with Java XML");
        }
        Element rootElem = xmlDoc.createElement("testscript");
        rootElem.setAttribute("version", "1.0");
        xmlDoc.appendChild(rootElem);
        this.sourceFile = toSave;
        for (int i = 0; i < this.tests.size(); ++i) {
            Test t = this.tests.get(i);
            Element testElem = xmlDoc.createElement("test");
            testElem.setAttribute("filename", t.getFileName());
            TestScript.addIOType(xmlDoc, testElem, "read", t.getRead());
            TestScript.addIOType(xmlDoc, testElem, "write", t.getWrite());
            TestScript.addIO(xmlDoc, testElem, "return", t.getReturnValue());
            rootElem.appendChild(testElem);
        }
        try {
            XMLUtils.writeXML(xmlDoc, new PrintWriter(new BufferedWriter(new FileWriter(toSave))));
        }
        catch (IOException e) {
            throw new TestScriptException("Error writing XML file");
        }
    }

    protected static void addIOType(Document xmlDoc, Element testElem, String classParam, Collection<Test.DataType> coll) {
        for (Test.DataType o : coll) {
            TestScript.addIO(xmlDoc, testElem, classParam, o);
        }
    }

    protected static void addIO(Document xmlDoc, Element testElem, String classParam, Test.DataType o) {
        Element ioElem = xmlDoc.createElement("io");
        ioElem.setAttribute("class", classParam);
        if (o instanceof Test.INT) {
            ioElem.setAttribute("type", "int");
            ioElem.appendChild(xmlDoc.createTextNode(Integer.toString(((Test.INT)o).intValue())));
        } else if (o instanceof Test.FLOAT) {
            ioElem.setAttribute("type", "float");
            ioElem.appendChild(xmlDoc.createTextNode(Float.toString(((Test.FLOAT)o).floatValue())));
        } else if (o instanceof Test.CH) {
            ioElem.setAttribute("type", "char");
            ioElem.appendChild(xmlDoc.createTextNode(Character.toString(((Test.CH)o).charValue())));
        } else if (o instanceof Test.MA) {
            ioElem.setAttribute("type", "ma");
            ioElem.appendChild(xmlDoc.createTextNode(Integer.toString(((Test.MA)o).intValue())));
        } else if (o instanceof Test.PA) {
            ioElem.setAttribute("type", "pa");
            ioElem.appendChild(xmlDoc.createTextNode(Integer.toString(((Test.PA)o).intValue())));
        } else if (o instanceof Test.STR) {
            ioElem.setAttribute("type", "string");
            ioElem.appendChild(xmlDoc.createTextNode(((Test.STR)o).stringValue()));
        } else {
            return;
        }
        testElem.appendChild(ioElem);
    }

    public boolean addTest(Test t) {
        if (this.testNames.contains(t.getFileName())) {
            return false;
        }
        this.testNames.add(t.getFileName());
        this.tests.add(t);
        if (this.autoSort) {
            Collections.sort(this.tests);
            Collections.sort(this.testNames);
        }
        return true;
    }

    public List<Test> getTests() {
        return this.tests;
    }

    public List<String> getTestNames() {
        return this.testNames;
    }

    public Test getTest(String testName) {
        int pos = this.testNames.indexOf(testName);
        if (pos < 0) {
            return null;
        }
        return this.tests.get(pos);
    }

    public void clearTests() {
        for (int i = 0; i < this.tests.size(); ++i) {
            this.tests.get(i).clear();
        }
    }

    public void deleteTest(int i) {
        this.tests.remove(i);
        this.testNames.remove(i);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TestThread
    extends SamThread {
        protected Processor proc;
        protected Sys sys;
        protected List<? extends Test> tests;
        public static final int THREAD_TEST_COMPLETED = 4;

        public TestThread(SamThread.ThreadParent parent, Sys sys, List<? extends Test> tests) {
            this.setParent(parent);
            this.sys = sys;
            this.tests = tests;
            this.proc = sys.cpu();
        }

        public void setTests(List<? extends Test> tests) {
            this.tests = tests;
        }

        public List<? extends Test> getTests() {
            return this.tests;
        }

        public Sys getSys() {
            return this.sys;
        }

        @Override
        public void execute() throws TestScriptException {
            SamThread.ThreadParent parent = this.getParent();
            for (int i = 0; i < this.tests.size(); ++i) {
                if (this.interruptRequested()) {
                    parent.threadEvent(0, null);
                    return;
                }
                Test test = this.tests.get(i);
                int status = test.run(this.sys, this);
                parent.threadEvent(status, null);
            }
            parent.threadEvent(2, null);
        }
    }

    public static class TestScriptException
    extends Exception {
        private String message;
        private Throwable t;

        public TestScriptException(String message) {
            this.message = message;
        }

        public TestScriptException(String message, Throwable t) {
            this.message = message;
            this.t = t;
        }

        public String getMessage() {
            return this.message;
        }

        public Throwable getCause() {
            return this.t;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Test
    implements Video,
    Serializable,
    Comparable {
        protected String fileName = null;
        protected Queue<DataType> rqueue = new LinkedList<DataType>();
        protected Queue<DataType> wqueue = new LinkedList<DataType>();
        protected Queue<DataType> runReadQueue = null;
        protected Queue<DataType> runWriteQueue = null;
        protected DataType returnValue;
        protected boolean completed = false;
        protected DataType actualReturnValue = null;
        protected boolean ioSuccessful = true;
        protected boolean stackCleared = true;
        protected List<ProgramState> stateSteps = new ArrayList<ProgramState>();
        protected TestScript scriptFile;
        protected Program code = null;

        public Test(String fileName) {
            this.fileName = fileName;
        }

        public TestResult getTestResult() {
            return this.getTestResult(new TestResult(this.fileName));
        }

        protected TestResult getTestResult(TestResult tr) {
            tr.setReturnValue(this.actualReturnValue);
            tr.setStackCleared(this.stackCleared);
            tr.setIOSuccessful(this.ioSuccessful);
            return tr;
        }

        public int compareTo(Object o) {
            Test t = (Test)o;
            return this.fileName.compareTo(t.fileName);
        }

        public void clear() {
            this.completed = false;
            this.ioSuccessful = true;
            this.actualReturnValue = null;
            this.stackCleared = true;
            this.runReadQueue = (LinkedList)((LinkedList)this.rqueue).clone();
            this.runWriteQueue = (LinkedList)((LinkedList)this.wqueue).clone();
            this.stateSteps = new ArrayList<ProgramState>();
        }

        public void addToRead(DataType o) {
            this.rqueue.offer(o);
        }

        public void addToWrite(DataType o) {
            this.wqueue.offer(o);
        }

        public Queue<DataType> getRead() {
            return this.rqueue;
        }

        public Queue<DataType> getWrite() {
            return this.wqueue;
        }

        public String getFileName() {
            if (this.scriptFile != null && this.scriptFile.getSourceFile() != null) {
                File f = new File(this.fileName);
                f = new File(this.scriptFile.getSourceFile().getParent(), f.getName());
                if (f.exists()) {
                    return f.getName();
                }
            }
            return this.fileName;
        }

        public File getFile() {
            File f = new File(this.fileName);
            if (f.exists()) {
                return f;
            }
            if (this.scriptFile != null && this.scriptFile.getSourceFile() != null) {
                f = new File(this.scriptFile.getSourceFile().getParent(), f.getName());
            }
            if (f.exists()) {
                return f;
            }
            return new File(this.fileName);
        }

        public DataType getReturnValue() {
            return this.returnValue;
        }

        public void setFileName(String string) {
            this.fileName = string;
        }

        public void setReturnValue(DataType o) {
            this.returnValue = o;
        }

        public DataType getActualReturnValue() {
            return this.actualReturnValue;
        }

        public boolean isCompleted() {
            return this.completed;
        }

        public boolean isIoSuccessful() {
            return this.ioSuccessful;
        }

        public boolean error() {
            if (!this.returnValue.equals(this.actualReturnValue)) {
                return true;
            }
            if (!this.ioSuccessful) {
                return true;
            }
            return !this.stackCleared;
        }

        public boolean isStackCleared() {
            return this.stackCleared;
        }

        public List<ProgramState> getStateSteps() {
            return this.stateSteps;
        }

        public void addStep(ProgramState step) {
            this.stateSteps.add(step);
        }

        public void resetState() {
            this.stateSteps = new ArrayList<ProgramState>();
        }

        public TestScript getScriptFile() {
            return this.scriptFile;
        }

        public void setScriptFile(TestScript file) {
            this.scriptFile = file;
        }

        public void setRead(Collection<DataType> collection) {
            this.rqueue = new LinkedList<DataType>(collection);
        }

        public void setWrite(Collection<DataType> collection) {
            this.wqueue = new LinkedList<DataType>(collection);
        }

        public void assemble() throws TestScriptException {
            try {
                this.code = SamAssembler.assemble(new BufferedReader(new FileReader(this.getFile())));
            }
            catch (FileNotFoundException e) {
                throw new TestScriptException("Could not find test (" + this.getFileName() + ")");
            }
            catch (AssemblerException e) {
                throw new TestScriptException("Assembler reported error with test " + this.getFileName());
            }
            catch (IOException e) {
                throw new TestScriptException("I/O Error while reading test");
            }
        }

        public Program getCode() throws TestScriptException {
            if (this.code == null) {
                this.assemble();
            }
            return this.code;
        }

        public int run(Sys sys, SamThread thread) throws TestScriptException {
            this.clear();
            Processor proc = sys.cpu();
            Memory mem = sys.mem();
            proc.init();
            mem.init();
            sys.setVideo(this);
            try {
                proc.load(this.getCode());
                while (proc.get(3) != 1) {
                    if (thread != null && thread.interruptRequested()) {
                        return 0;
                    }
                    int executing = proc.get(0);
                    proc.step();
                    this.addStep(new ProgramState(executing, mem.getStack(), proc.getRegisters()));
                }
                switch (mem.getType(0)) {
                    case CH: {
                        this.actualReturnValue = new CH((char)mem.getValue(0));
                        break;
                    }
                    case FLOAT: {
                        this.actualReturnValue = new FLOAT(Float.intBitsToFloat(mem.getValue(0)));
                        break;
                    }
                    case INT: {
                        this.actualReturnValue = new INT(mem.getValue(0));
                        break;
                    }
                    case PA: {
                        this.actualReturnValue = new PA(mem.getValue(0));
                        break;
                    }
                    case MA: {
                        this.actualReturnValue = new MA(mem.getValue(0));
                        break;
                    }
                    default: {
                        this.actualReturnValue = null;
                    }
                }
                if (proc.get(1) != 1) {
                    this.stackCleared = false;
                }
                if (!this.runReadQueue.isEmpty() || !this.runWriteQueue.isEmpty()) {
                    this.ioSuccessful = false;
                }
            }
            catch (SystemException e) {
                this.actualReturnValue = null;
            }
            this.completed = true;
            return 4;
        }

        @Override
        public int readInt() {
            if (this.runReadQueue.isEmpty() || !(this.runReadQueue.peek() instanceof INT)) {
                this.ioSuccessful = false;
                return 0;
            }
            return ((INT)this.runReadQueue.remove()).intValue();
        }

        @Override
        public String readString() {
            if (this.runReadQueue.isEmpty() || !(this.runReadQueue.peek() instanceof STR)) {
                this.ioSuccessful = false;
                return "";
            }
            return ((STR)this.runReadQueue.remove()).stringValue();
        }

        @Override
        public char readChar() {
            if (this.runReadQueue.isEmpty() || !(this.runReadQueue.peek() instanceof CH)) {
                this.ioSuccessful = false;
                return '\u0000';
            }
            return ((CH)this.runReadQueue.remove()).charValue();
        }

        @Override
        public float readFloat() {
            if (this.runReadQueue.isEmpty() || !(this.runReadQueue.peek() instanceof FLOAT)) {
                this.ioSuccessful = false;
                return 0.0f;
            }
            return ((FLOAT)this.runReadQueue.remove()).floatValue();
        }

        @Override
        public void writeInt(int a) {
            if (this.runWriteQueue.isEmpty() || !(this.runWriteQueue.peek() instanceof INT) || ((INT)this.runWriteQueue.remove()).intValue() != a) {
                this.ioSuccessful = false;
            }
        }

        @Override
        public void writeFloat(float a) {
            if (this.runWriteQueue.isEmpty() || !(this.runWriteQueue.peek() instanceof FLOAT) || ((FLOAT)this.runWriteQueue.remove()).floatValue() != a) {
                this.ioSuccessful = false;
            }
        }

        @Override
        public void writeChar(char a) {
            if (this.runWriteQueue.isEmpty() || !(this.runWriteQueue.peek() instanceof CH) || ((CH)this.runWriteQueue.remove()).charValue() != a) {
                this.ioSuccessful = false;
            }
        }

        @Override
        public void writeString(String a) {
            if (this.runWriteQueue.isEmpty() || !(this.runWriteQueue.peek() instanceof STR) || !a.equals(((STR)this.runWriteQueue.remove()).stringValue())) {
                this.ioSuccessful = false;
            }
        }

        public static class PA
        extends DataType {
            int value;

            public PA(int v) {
                this.value = v;
            }

            public boolean equals(Object o) {
                if (o instanceof PA) {
                    return this.value == ((PA)o).value;
                }
                return false;
            }

            public String toString() {
                return "PA(" + this.value + ")";
            }

            public int intValue() {
                return this.value;
            }
        }

        public static class INT
        extends DataType {
            int value;

            public INT(int v) {
                this.value = v;
            }

            public boolean equals(Object o) {
                if (o instanceof INT) {
                    return this.value == ((INT)o).value;
                }
                return false;
            }

            public String toString() {
                return "INT(" + this.value + ")";
            }

            public int intValue() {
                return this.value;
            }
        }

        public static class FLOAT
        extends DataType {
            float value;

            public FLOAT(float v) {
                this.value = v;
            }

            public boolean equals(Object o) {
                if (o instanceof FLOAT) {
                    return this.value == ((FLOAT)o).value;
                }
                return false;
            }

            public String toString() {
                return "FLOAT(" + this.value + ")";
            }

            public float floatValue() {
                return this.value;
            }
        }

        public static class STR
        extends DataType {
            String value;

            public STR(String v) {
                this.value = v;
            }

            public boolean equals(Object o) {
                if (o instanceof STR) {
                    return this.value == ((STR)o).value;
                }
                return false;
            }

            public String toString() {
                return "STR(" + this.value + ")";
            }

            public String stringValue() {
                return this.value;
            }
        }

        public static class CH
        extends DataType {
            char value;

            public CH(char v) {
                this.value = v;
            }

            public boolean equals(Object o) {
                if (o instanceof CH) {
                    return this.value == ((CH)o).value;
                }
                return false;
            }

            public String toString() {
                return "CH(" + this.value + ")";
            }

            public char charValue() {
                return this.value;
            }
        }

        public static class MA
        extends DataType {
            int value;

            public MA(int v) {
                this.value = v;
            }

            public boolean equals(Object o) {
                if (o instanceof MA) {
                    return this.value == ((MA)o).value;
                }
                return false;
            }

            public String toString() {
                return "MA(" + this.value + ")";
            }

            public int intValue() {
                return this.value;
            }
        }

        public static abstract class DataType
        implements Serializable {
        }
    }

    public static class TestResult
    implements Serializable {
        protected String testName = null;
        protected Test.DataType returnValue = null;
        protected boolean stackCleared = false;
        protected boolean ioSuccessful = false;

        public TestResult(String testName) {
            this.testName = testName;
        }

        public String getTestName() {
            return this.testName;
        }

        public Test.DataType getReturnValue() {
            return this.returnValue;
        }

        public void setReturnValue(Test.DataType returnValue) {
            this.returnValue = returnValue;
        }

        public boolean isStackCleared() {
            return this.stackCleared;
        }

        public boolean isIOSuccessful() {
            return this.ioSuccessful;
        }

        public void setStackCleared(boolean s) {
            this.stackCleared = s;
        }

        public void setIOSuccessful(boolean s) {
            this.ioSuccessful = s;
        }

        public Properties saveToProperties() throws IOException {
            return this.saveToProperties(true);
        }

        protected Properties saveToProperties(boolean saveTestResult) throws IOException {
            Properties props = new Properties();
            props.setProperty("testname", this.testName);
            props.setProperty("stackcleared", Boolean.toString(this.stackCleared));
            props.setProperty("iosuccessful", Boolean.toString(this.ioSuccessful));
            if (!saveTestResult) {
                return props;
            }
            if (this.returnValue instanceof Test.INT) {
                props.setProperty("returnvaluetype", "int");
                props.setProperty("returnvalue", Integer.toString(((Test.INT)this.returnValue).intValue()));
            } else if (this.returnValue instanceof Test.FLOAT) {
                props.setProperty("returnvaluetype", "float");
                props.setProperty("returnvalue", Float.toString(((Test.FLOAT)this.returnValue).floatValue()));
            } else if (this.returnValue instanceof Test.CH) {
                props.setProperty("returnvaluetype", "char");
                props.setProperty("returnvalue", Character.toString(((Test.CH)this.returnValue).charValue()));
            } else if (this.returnValue instanceof Test.MA) {
                props.setProperty("returnvaluetype", "ma");
                props.setProperty("returnvalue", Integer.toString(((Test.MA)this.returnValue).intValue()));
            } else if (this.returnValue instanceof Test.PA) {
                props.setProperty("returnvaluetype", "pa");
                props.setProperty("returnvalue", Integer.toString(((Test.PA)this.returnValue).intValue()));
            } else if (this.returnValue instanceof Test.STR) {
                props.setProperty("returnvaluetype", "string");
                props.setProperty("returnvalue", this.returnValue.toString());
            } else if (this.returnValue != null) {
                throw new IOException("Invalid Test Results" + this.returnValue);
            }
            return props;
        }

        public void loadFromProperties(Properties props) throws IOException {
            this.loadFromProperties(props, true);
        }

        protected void loadFromProperties(Properties props, boolean loadRetVal) throws IOException {
            block14: {
                this.testName = props.getProperty("testname");
                if (this.testName == null) {
                    throw new IOException("Invalid test results");
                }
                if (props.getProperty("stackcleared") == null) {
                    throw new IOException("Invalid test results");
                }
                if (props.getProperty("iosuccessful") == null) {
                    throw new IOException("Invalid test results");
                }
                this.stackCleared = props.getProperty("stackcleared").equals("true");
                this.ioSuccessful = props.getProperty("iosuccessful").equals("true");
                if (!loadRetVal) {
                    return;
                }
                String type = props.getProperty("returnvaluetype");
                String value = props.getProperty("returnvalue");
                if (type != null && value != null) {
                    try {
                        if (type.equals("int")) {
                            this.returnValue = new Test.INT(Integer.parseInt(value));
                            break block14;
                        }
                        if (type.equals("float")) {
                            this.returnValue = new Test.FLOAT(Float.parseFloat(value));
                            break block14;
                        }
                        if (type.equals("ma")) {
                            this.returnValue = new Test.MA(Integer.parseInt(value));
                            break block14;
                        }
                        if (type.equals("pa")) {
                            this.returnValue = new Test.PA(Integer.parseInt(value));
                            break block14;
                        }
                        if (type.equals("char") && value.length() == 1) {
                            this.returnValue = new Test.CH(value.charAt(0));
                            break block14;
                        }
                        if (type.equals("char")) {
                            throw new IOException("Invalid test results");
                        }
                        if (type.equals("string")) {
                            this.returnValue = new Test.STR(value);
                            break block14;
                        }
                        throw new IOException("Invalid test results");
                    }
                    catch (NumberFormatException e) {
                        throw new IOException("Invalid test results");
                    }
                }
            }
        }
    }
}

