/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cs.sam.core;

import edu.cornell.cs.sam.core.ExplicitFreeAllocator;
import edu.cornell.cs.sam.core.Memory;
import edu.cornell.cs.sam.core.Processor;
import edu.cornell.cs.sam.core.SamMemory;
import edu.cornell.cs.sam.core.SamProcessor;
import edu.cornell.cs.sam.core.Video;
import edu.cornell.cs.sam.utils.RegistrationSystem;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sys {
    public static final String SAM_VERSION = "2.6.3";
    private int procID = RegistrationSystem.getNextUID();
    private int memID = RegistrationSystem.getNextUID();
    private int vidID = RegistrationSystem.getNextUID();

    public Processor cpu() {
        return (Processor)RegistrationSystem.getElement(this.procID);
    }

    public Collection<Processor> cpus() {
        return RegistrationSystem.getElements(this.procID);
    }

    public Memory mem() {
        return (Memory)RegistrationSystem.getElement(this.memID);
    }

    public Video video() {
        return (Video)RegistrationSystem.getElement(this.vidID);
    }

    public void setVideo(Video v) {
        RegistrationSystem.register(this.vidID, v);
    }

    public Sys() {
        this(1);
    }

    public Sys(int n) {
        for (int i = 0; i < n; ++i) {
            RegistrationSystem.register(this.procID, new SamProcessor(this));
        }
        SamMemory mem = new SamMemory(this);
        mem.setHeapAllocator(new ExplicitFreeAllocator());
        mem.getHeapAllocator().setMemory(mem);
        RegistrationSystem.register(this.memID, mem);
    }
}

