#ifndef GBA_BG_H
#define GBA_BG_H
 
 
///BGCNT defines ///
//For Tile BG modes
#define BG_MOSAIC_ENABLE                   0x40
#define BG_COLOR_256                              0x80
#define BG_COLOR_16                                0x0
 
#define CharBaseBlock(n)                   (((n)*0x4000)+0x6000000)
#define ScreenBaseBlock(n)                (((n)*0x800)+0x6000000)
 
#define CHAR_SHIFT                                   2
#define SCREEN_SHIFT                               8
#define TEXTBG_SIZE_256x256                  0x0
#define TEXTBG_SIZE_256x512                  0x8000
#define TEXTBG_SIZE_512x256                  0x4000
#define TEXTBG_SIZE_512x512                  0xC000
 
#define ROTBG_SIZE_128x128                    0x0
#define ROTBG_SIZE_256x256                    0x4000
#define ROTBG_SIZE_512x512                    0x8000
#define ROTBG_SIZE_1024x1024                0xC000

#define REG_BG0CNT     	(*(u16*)0x4000008)//BG0 information data
#define REG_BG1CNT     	(*(u16*)0x400000A)
#define REG_BG2CNT     	(*(u16*)0x400000C)
#define REG_BG3CNT     	(*(u16*)0x400000E)
#define REG_BG0HOFS    	(*(u16*)0x4000010)//BG0 horizontal offset
#define REG_BG0VOFS    	(*(u16*)0x4000012)//BG0 vertical offset
#define REG_BG1HOFS    	(*(u16*)0x4000014)
#define REG_BG1VOFS    	(*(u16*)0x4000016)
#define REG_BG2HOFS    	(*(u16*)0x4000018)
#define REG_BG2VOFS    	(*(u16*)0x400001A)
#define REG_BG3HOFS    	(*(u16*)0x400001C)
#define REG_BG3VOFS    	(*(u16*)0x400001E)
 
#define WRAPAROUND                   0x1
 
#endif
