/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cs.sam.core;

import edu.cornell.cs.sam.core.Program;
import edu.cornell.cs.sam.core.ReferenceTable;
import edu.cornell.cs.sam.core.SamReferenceTable;
import edu.cornell.cs.sam.core.SamSymbolTable;
import edu.cornell.cs.sam.core.SymbolTable;
import edu.cornell.cs.sam.core.instructions.Instruction;
import edu.cornell.cs.sam.core.instructions.SamIntInstruction;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SamProgram
implements Program,
Serializable {
    private List<Instruction> instructions = new ArrayList<Instruction>();
    private SymbolTable syms = new SamSymbolTable();
    private ReferenceTable refs = new SamReferenceTable();
    private static final String BR = System.getProperty("line.separator");

    @Override
    public Instruction getInst(int pos) {
        return this.instructions.get(pos);
    }

    @Override
    public List<Instruction> getInstList() {
        return this.instructions;
    }

    @Override
    public void addInst(Instruction i) {
        this.instructions.add(i);
    }

    @Override
    public void addInst(Instruction[] arr) {
        for (int a = 0; a < arr.length; ++a) {
            this.instructions.add(arr[a]);
        }
    }

    @Override
    public int getLength() {
        return this.instructions.size();
    }

    @Override
    public SymbolTable getSymbolTable() {
        return this.syms;
    }

    @Override
    public ReferenceTable getReferenceTable() {
        return this.refs;
    }

    @Override
    public void setSymbolTable(SymbolTable table) {
        this.syms = table;
    }

    @Override
    public void setReferenceTable(ReferenceTable table) {
        this.refs = table;
    }

    private static void resolve(SymbolTable syms, ReferenceTable refs, List<Instruction> instructions) {
        Collection<String> symbols = syms.getSymbols();
        for (String sym : symbols) {
            int address = syms.resolveAddress(sym);
            Collection<Integer> references = refs.getReferences(sym);
            if (references != null) {
                for (Integer ref : references) {
                    ((SamIntInstruction)instructions.get(ref)).setOperand(address);
                }
            }
            refs.deleteSymbol(sym);
        }
    }

    @Override
    public void resolveReferences() {
        SamProgram.resolve(this.syms, this.refs, this.instructions);
    }

    @Override
    public void resolveReferencesFrom(Program prog) {
        SamProgram.resolve(this.syms, prog.getReferenceTable(), prog.getInstList());
    }

    @Override
    public boolean isExecutable() {
        return this.refs.size() == 0;
    }

    public String toString() {
        String toReturn = "Instructions: " + BR;
        for (int i = 0; i < this.instructions.size(); ++i) {
            toReturn = toReturn + i + ": " + this.instructions.get(i) + BR;
        }
        toReturn = toReturn + BR + "Symbol Table:" + BR + ((Object)this.syms).toString() + BR + "Reference Table:" + BR + ((Object)this.refs).toString();
        return toReturn;
    }
}

