import java.io.PrintWriter;

/**
 * This implements a variable 
 */
public class VariableExpression implements Expression, BaliLvalueNode {

	/* Variable classes, depending on scope */
	public enum VariableType{
		LOCAL, GLOBAL;
	}
    
	/* Name, class, and data type of the variable */
	private String name;
	private VariableType varType;
	private DataType dataType = DataType.INT;
	
	/* The address of the variable */
	private int address = -1;

	
	/**
	 * Creates a new variable with the provided name
	 * @param name The name of the new variable
	 * @param dataType The type of the variable
	 * @param varType The variable class (function, global, or parameter)
	 */
	public VariableExpression(String name, DataType dataType, VariableType varType) {
		this.name = name;
		this.dataType = dataType;
		this.varType = varType;
	}

	/**
	 * Returns the name of this variable
	 * @return The variable name
	 */
	public String getName() {
		return name;
	}

	/**
	 * Sets the address of the variable
	 * @param the address of the variable
	 */
	public void setAddress(int address) {
		this.address = address;
	}
	
	/**
	 * Gets the address of the variable
	 * @return the address of the variable
	 */
	public int getAddress() {
		return address;
	}

	/**
	 * Returns the type of this variable
	 * @return The data type.
	 */
	public DataType getReturnType() {
		return dataType;
	}

	
	/**
	 * Returns if this is a valid lvalue
	 * @return true 
	 */
	public boolean isValidLvalue() {
		return true;
	}
	
	/**
	 * Prints out code to set the variable to the topmost value on the stack
	 * @param out The print writer
	 */
	public void printSamLvalueCode(PrintWriter out) {
		/* Global Variable */
		if(varType == VariableType.GLOBAL)
			out.println("STOREABS " + address);

		/* Local Variable */
		if (varType == VariableType.LOCAL) 
			out.println("STOREOFF " + address);
	}

	/**
	 * Prints out code to put the variables current value on the stack
	 * @param out The print writer
	 */
	public void printSamCode(PrintWriter out) {

		/* Global Variable */
		if(varType == VariableType.GLOBAL)
			out.println("PUSHABS " + address);

		/* Local Variable */
		else if (varType == VariableType.LOCAL) 
			out.println("PUSHOFF " + address);
	}

}
