import java.util.HashMap;

/**
 * SymbolTable provides a container for the variables of a scope
 */

public class SymbolTable {
	private HashMap<String, VariableExpression> vars = new HashMap<String, VariableExpression>();
	private VariableExpression.VariableType varType;	
	
	/**
	 * Creates a new symbol table with given type and parent scope
	 * @param varType the type of the variables in the table (local, parameter, or global)
	 */
	SymbolTable(VariableExpression.VariableType varType) {
		this.varType = varType;
	}
	
	/**
	 * Adds a new variable from the name and type information
	 * @param name The name of the variable
	 * @param dataType The data type of the variable
	 * @return The new variable
	 */
	public VariableExpression addVariable(String name, DataType dataType) {
		VariableExpression v = new VariableExpression(name, dataType, varType);
		v.setAddress(getNumberVariables() + 2);
		vars.put(name, v);
		return v;
	}
	
	/**
	 * Returns whether the symbol table contains a variable bound to the provided name
	 * @param name The name of the variable queried
	 * @return true if the variable is found in the symbol table 
	 */
	public boolean containsVariable(String name) {
		return vars.containsKey(name);
	}

	/**
	 * Returns the variable requested, or null if it does not exist
	 * @param name The name of the variable queried
	 * @return the variable requested, or null if it does not exist
	 */
	public VariableExpression getVariable(String name) {
		return vars.get(name);
	}

	/**
	 * Returns the number of variables
	 * @return The number of variables contained within this symbol table
	 */
	public int getNumberVariables() {
		return vars.size();
	}
}
