import java.io.PrintWriter;

/**
 * This implements a return statement
 */
public class ReturnStatement implements Statement{
	private Expression expr = null;
	private String endCallString;
	
	/**
	 * Creates a new returns statement
	 * @param endCallString the label for the end of the current function
	 */
	public ReturnStatement(String endCallString){
		this.endCallString = endCallString;
	}
	
	/**
	 * Sets the expression for this return statement 
	 * @param e The expression for this statement
	 */
	public void setExpression(Expression e){
		expr = e;
	}

	/**
	 * Sets the return value to the value of the expression
	 * @param out The print writer
	 */
	public void printSamCode(PrintWriter out) {

		/* Return expression */
		expr.printSamCode(out);
		out.println("JUMP " + endCallString);
		
	}
}
