import java.io.PrintWriter;

/**
 * Represents an read expression 
 */
public class ReadIntExpression implements Expression {
	
	/**
	 * Creates a readInt call
	 */
	public ReadIntExpression() {}

	/**
	 * Returns the type of this expression
	 * @return The type of this expression
	 */
	public DataType getReturnType(){
		return DataType.INT;
	}
	
	/**
	 * Uses the READ command to read an integer in
	 * @param out The print writer
	 */
	public void printSamCode(PrintWriter out) {
		out.println("READ");
	}
	
}
