import java.io.PrintWriter;

/**
 * Represents a read character expression 
 */
public class ReadCharExpression implements Expression {
	
	/**
	 * Creates a readChar call
	 */
	public ReadCharExpression() { }

	/**
	 * Returns the type of this expression
	 * @return The type of this expression
	 */
	public DataType getReturnType(){
		return DataType.CHAR;
	}
	
	/**
	 * Uses the READCH command to read a character in
	 * @param out The print writer
	 */
	public void printSamCode(PrintWriter out) {
		out.println("READCH");
	}
	
}
