import java.io.PrintWriter;

/**
 * This is a representations of a print statement (print expression)
 */
public class PrintStatement implements Statement {
	private Expression expr = null;
	
	/**
	 * Creates a PrintStatement
	 */
	public PrintStatement() { }

	/**
	 * Sets the expression to print
	 * @param e the expression
	 */
	public void setExpression(Expression e) {
		expr = e;
	}

	/**
	 * Prints out the SaM code for this print statement
	 * @param out The output stream
	 */
	public void printSamCode(PrintWriter out) {
		expr.printSamCode(out);
		DataType type = expr.getReturnType();
		
		if (type.equals(DataType.INT))
			out.println("WRITE");
		else if (type.equals(DataType.CHAR))
			out.println("WRITECH"); 
	}
}
