import java.io.PrintWriter;
/**
 * Creates an IfStatmenet of the form if expression then statement [else statement]
 */
public class IfStatement implements Statement {
	private Expression ifExpr = null;
	private Statement thenStatement = null;
	private Statement elseStatement = null;

	/**
	 * Creats an IfStatement
	 */
	public IfStatement() { }

	/**
	 * Sets the condition for this if statement
	 * @param e The condition
	 */
	public void setIfExpr(Expression e) {
		ifExpr = e;
	}

	/**
	 * Sets the "Then" block
	 * @param s The then block
	 */
	public void setThenStatement(Statement s) {
		thenStatement = s;
	}

	/**
	 * Sets the "Else" block
	 * @param b the else block
	 */
	public void setElseStatement(Statement s) {
		elseStatement = s;
	}

	/**
	 * Prints the SaM code for this if statement
	 * @param out The output stream
	 */
	public void printSamCode(PrintWriter out) {
		ifExpr.printSamCode(out);

		int number = Utils.getNumber();
		out.println("JUMPC thenif" + number);
		if (elseStatement != null)
			elseStatement.printSamCode(out);
		out.println("JUMP endif" + number);
		out.println("thenif" + number + ":");
		thenStatement.printSamCode(out);
		out.println("endif" + number + ":");
	}

}
