import java.io.PrintWriter;

/**
 * This class represents a for loop 
 */
public class ForStatement implements Statement {
	private Expression initExpr = null;
	private Expression condition = null;
	private Expression repeatExpr = null;
	private Statement stat = null;
	
	/**
	 * Creates a new ForStatement
	 */
	public ForStatement() { }

	/**
	 * Sets the initial expression
	 * @param e The expression to set
	 */
	public void setInitExpr(Expression e) {
		initExpr = e;
	}

	/**
	 * Sets the repeat expression
	 * @param e The expression to set
	 */
	public void setRepeatExpr(Expression e) {
		repeatExpr = e;
	}

	/**
	 * Sets the loop condition
	 * @param e The loop condition
	 */
	public void setCondition(Expression e) {
		condition = e;	
	}

	/**
	 * Sets the loop statement
	 * @param s The loop statement
	 */
	public void setStatement(Statement s) {
		stat = s;
	}

	/**
	 * Prints the SaM code for this loop
	 * @param out The print writer
	 */
	public void printSamCode(PrintWriter out) {
		int number = Utils.getNumber();

		/* Print initial expression */
		if (initExpr != null) {
			initExpr.printSamCode(out);
			out.println("ADDSP -1");
		}

		/* Print the condition */
		out.println("beginfor" + number + ':');
		if (condition != null) {
			condition.printSamCode(out);
			out.println("ISNIL");
			out.println("JUMPC endfor" + number);
		}
			
		/* Print the loop code */
		stat.printSamCode(out);

		/* print the end of repeat expression */
		if (repeatExpr != null) {
			repeatExpr.printSamCode(out);
			out.println("ADDSP -1");
		}
		
		out.println("JUMP beginfor" + number);
		out.println("endfor" + number + ':');
			
	}
}
