import java.io.PrintWriter;

/**
 * This represents an expression statement of the form: expr;
 * We just run the expression and remove the result
 */
public class ExpressionStatement implements Statement {
	private Expression expr = null;
	
	/**
	 * Creates a new ExpressionStatement with the provided expression
	 */
	public ExpressionStatement() { }

	/**
	 * Set the expression for this statement 
	 * @param expr The expression
	 */
	public void setExpression(Expression expr) {
		this.expr = expr;
	}

	/**
	 * Prints out the code for the expression, and then removes the
	 * result from the stack
	 * @param out The print writer
	 */
	public void printSamCode(PrintWriter out) {
		if (expr != null) {
			expr.printSamCode(out);
			out.println("ADDSP -1");
		}
	}
}
