import java.io.PrintWriter;

/**
 * This is a representations of a DoUntil loop
 */
public class DoUntilStatement implements Statement {
	private Expression condition = null;
	private Statement loopStatement = null;

	/**
	 * Creates a DoUntilStatement
	 */
	public DoUntilStatement() {	}

	/**
	 * Sets the condition for this DoUntil loop
	 * @param e the conditon
	 */
	public void setCondition(Expression e) {
		condition = e;
	}

	/**
	 * Sets the loop statement for this DoUntil loop
	 * @param s the loop
	 */
	public void setLoopStatement(Statement s) {
		loopStatement = s;
	}

	/**
	 * Prints out the SaM code for this DoUntil loop
	 * @param out The output stream
	 */
	public void printSamCode(PrintWriter out) {
		int number = Utils.getNumber();
		out.println("begindountil" + number + ":");
		loopStatement.printSamCode(out);
		condition.printSamCode(out);
		out.println("NOT");
		out.println("JUMPC begindountil" + number);
	}

}
