import java.io.PrintWriter;

/**
 * Represents a Bali constant
 */
public class ConstantExpression implements Expression {
	private Object value = null;
	private DataType type = null;

	/**
	 * Creates a new integer constant with the provided value
	 * @param value The value of this constant
	 */
	public ConstantExpression(int value) {
		this.value = new Integer(value);
		this.type = DataType.INT;
	}

	/**
	 * Creates a new boolean constant with the provided value
	 * @param value The value of this constant
	 */
	public ConstantExpression(boolean value) {
		this.value = new Boolean(value);
		this.type = DataType.BOOLEAN;
	}

	/**
	 * Creates a new character constant with the provided value
	 * @param value The value of this constant
	 */
	public ConstantExpression(char value) {
		this.value = new Character(value);
		this.type = DataType.CHAR;
	}

	/**
	 * Returns the type of this expression
	 */
	public DataType getReturnType() {
		return type;
	}

	/**
	 * Puts the constant on the stack
	 * @param out The print writer
	 */
	public void printSamCode(PrintWriter out) {
		if (type.equals(DataType.INT))
			out.println("PUSHIMM " + value);
	
		else if (type.equals(DataType.BOOLEAN)) 
			out.println("PUSHIMM " + (((Boolean) value).booleanValue() ? 1 : 0));

		else if (type.equals(DataType.CHAR))
			out.println("PUSHIMMCH '" + value.toString().replace("'", "\\'") + "'");
	}
}
