import java.io.PrintWriter;
import java.util.List;
import java.util.ArrayList;

/**
 * This represents a block of statements
 */

public class BlockStatement implements Statement {
	List<Statement> statements = new ArrayList<Statement>();

	/**
	 * Creates a new Block Statement
	 * @param parent The parent scope
	 */
	public BlockStatement() { }

	/**
	 * Adds a statement to the block
	 * @param stat The statement to add
	 */
	public void addStatement(Statement stat) {
		if (stat != null) statements.add(stat);
	}

	/**
	 * Returns the number of statements
	 * @return The number of statements in this statement block 
	 */
	public int getNumberStatements(){
		return statements.size();
	}

	/**
	 * Prints the SaM code for this block to a stream
	 * Tells each statement in the block to print its SaM code
	 * @param out The output stream
	 */
	public void printSamCode(PrintWriter out) {
		for (Statement stat: statements)
			stat.printSamCode(out);
	}

}
