import java.io.PrintWriter;

/**
 * This represents a Bali program and contains
 * space to store a global variable symbol table and other information
 */
public class BaliProgram implements BaliNode {
	private SymbolTable globals;
	private SymbolTable locals;
	private BlockStatement body;
	
	
	/**
	 * Creates a new Program
	 */
	public BaliProgram(SymbolTable globals, SymbolTable locals, BlockStatement body) {
		this.globals = globals;
		this.locals = locals;
		this.body = body;
	}

	
	/**
	 * Bootstraps main and prints out the main function
	 * @param out The print writer 
	 */
	public void printSamCode(PrintWriter out) {
		int vcount = globals.getNumberVariables();

		/* Allocate globals and return value */
		out.println("ADDSP " + (vcount+1));
		
		/* Execute a call to main */
		// Set aside rv
		out.println("ADDSP 1");		
		out.println("LINK");
		out.println("JSR " + Utils.mainCallString);
		out.println("UNLINK");
				
		/* Put the return value into slot 0 and remove the global vars */
		out.println("STOREABS 0");

		/* Deallocate globals */
		if (vcount > 0)
			out.println("ADDSP -" + vcount);

		/* And now stop */
		out.println("STOP");

		/* Finally print code for main */
		
		/* Function label */
		out.println(Utils.mainCallString + ":");
		
		/* Allocate space for local variables */
		out.println("ADDSP " + locals.getNumberVariables());

		/* Print out the statements */
		body.printSamCode(out);

		/* End code for implicit return: store return value */
        out.println("PUSHIMM 0");
		
        /* The rest of the end code */
        out.println(Utils.mainEndCallString + ":");
        out.println("STOREOFF -1");
        out.println("ADDSP " + -locals.getNumberVariables());
        out.println("RST");
	}
		
}
